/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.elements;

import rst.pdfbox.layout.elements.ControlElement;

public class PositionControl
extends ControlElement {
    public static final Float MARKED_POSITION = Float.valueOf(Float.NEGATIVE_INFINITY);

    public static MarkPosition createMarkPosition() {
        return new MarkPosition();
    }

    public static SetPosition createSetPosition(Float newX, Float newY) {
        return new SetPosition(newX, newY);
    }

    public static MovePosition createMovePosition(float relativeX, float relativeY) {
        return new MovePosition(relativeX, relativeY);
    }

    private PositionControl(String name) {
        super(name);
    }

    public static class MovePosition
    extends PositionControl {
        private float relativeX;
        private float relativeY;

        private MovePosition(float relativeX, float relativeY) {
            super(String.format("SET_POSITION x:%f, y%f", Float.valueOf(relativeX), Float.valueOf(relativeY)));
            this.relativeX = relativeX;
            this.relativeY = relativeY;
        }

        public float getX() {
            return this.relativeX;
        }

        public float getY() {
            return this.relativeY;
        }
    }

    public static class SetPosition
    extends PositionControl {
        private Float newX;
        private Float newY;

        private SetPosition(Float newX, Float newY) {
            super(String.format("SET_POSITION x:%f, y%f", newX, newY));
            this.newX = newX;
            this.newY = newY;
        }

        public Float getX() {
            return this.newX;
        }

        public Float getY() {
            return this.newY;
        }
    }

    public static class MarkPosition
    extends PositionControl {
        private MarkPosition() {
            super("MARK_POSITION");
        }
    }
}

