/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.shaded.gherkin.messages.internal.gherkin;

import io.cucumber.shaded.gherkin.messages.internal.gherkin.internal.com.eclipsesource.json.JsonArray;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.internal.com.eclipsesource.json.JsonObject;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.internal.com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.List;

public class GherkinDialect {
    private final JsonObject keywords;
    private String language;

    public GherkinDialect(String language, JsonObject keywords) {
        this.language = language;
        this.keywords = keywords;
    }

    public List<String> getFeatureKeywords() {
        return GherkinDialect.toStringList(this.keywords.get("feature").asArray());
    }

    private static List<String> toStringList(JsonArray array) {
        ArrayList<String> result = new ArrayList<String>();
        for (JsonValue jsonValue : array) {
            result.add(jsonValue.asString());
        }
        return result;
    }

    public String getName() {
        return this.keywords.getString("name", null);
    }

    public String getNativeName() {
        return this.keywords.getString("native", null);
    }

    public List<String> getRuleKeywords() {
        return GherkinDialect.toStringList(this.keywords.get("rule").asArray());
    }

    public List<String> getScenarioKeywords() {
        return GherkinDialect.toStringList(this.keywords.get("scenario").asArray());
    }

    public List<String> getScenarioOutlineKeywords() {
        return GherkinDialect.toStringList(this.keywords.get("scenarioOutline").asArray());
    }

    public List<String> getStepKeywords() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getGivenKeywords());
        result.addAll(this.getWhenKeywords());
        result.addAll(this.getThenKeywords());
        result.addAll(this.getAndKeywords());
        result.addAll(this.getButKeywords());
        return result;
    }

    public List<String> getBackgroundKeywords() {
        return GherkinDialect.toStringList(this.keywords.get("background").asArray());
    }

    public List<String> getExamplesKeywords() {
        return GherkinDialect.toStringList(this.keywords.get("examples").asArray());
    }

    public List<String> getGivenKeywords() {
        return GherkinDialect.toStringList(this.keywords.get("given").asArray());
    }

    public List<String> getWhenKeywords() {
        return GherkinDialect.toStringList(this.keywords.get("when").asArray());
    }

    public List<String> getThenKeywords() {
        return GherkinDialect.toStringList(this.keywords.get("then").asArray());
    }

    public List<String> getAndKeywords() {
        return GherkinDialect.toStringList(this.keywords.get("and").asArray());
    }

    public List<String> getButKeywords() {
        return GherkinDialect.toStringList(this.keywords.get("but").asArray());
    }

    public String getLanguage() {
        return this.language;
    }
}

