/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.shaded.gherkin.messages.internal.gherkin;

import io.cucumber.shaded.gherkin.messages.internal.gherkin.GherkinDocumentBuilder;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.GherkinException;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.Parser;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.ParserException;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.pickles.PickleCompiler;
import io.cucumber.shaded.messages.IdGenerator;
import io.cucumber.shaded.messages.types.Envelope;
import io.cucumber.shaded.messages.types.GherkinDocument;
import io.cucumber.shaded.messages.types.Location;
import io.cucumber.shaded.messages.types.ParseError;
import io.cucumber.shaded.messages.types.Pickle;
import io.cucumber.shaded.messages.types.Source;
import io.cucumber.shaded.messages.types.SourceReference;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class Gherkin {
    private final List<String> paths;
    private final List<Envelope> envelopes;
    private final boolean includeSource;
    private final boolean includeAst;
    private final boolean includePickles;
    private final IdGenerator idGenerator;

    private Gherkin(List<String> paths, List<Envelope> envelopes, boolean includeSource, boolean includeAst, boolean includePickles, IdGenerator idGenerator) {
        this.paths = paths;
        this.envelopes = envelopes;
        this.includeSource = includeSource;
        this.includeAst = includeAst;
        this.includePickles = includePickles;
        this.idGenerator = idGenerator;
    }

    public static Stream<Envelope> fromPaths(List<String> paths, boolean includeSource, boolean includeAst, boolean includePickles, IdGenerator idGenerator) {
        return new Gherkin(paths, null, includeSource, includeAst, includePickles, idGenerator).messages();
    }

    public static Stream<Envelope> fromSources(List<Envelope> envelopes, boolean includeSource, boolean includeAst, boolean includePickles, IdGenerator idGenerator) {
        return new Gherkin(Collections.emptyList(), envelopes, includeSource, includeAst, includePickles, idGenerator).messages();
    }

    public static Envelope makeSourceEnvelope(String data, String uri) {
        Envelope envelope = new Envelope();
        envelope.setSource(new Source(uri, data, Source.MediaType.TEXT_X_CUCUMBER_GHERKIN_PLAIN));
        return envelope;
    }

    public Stream<Envelope> messages() {
        Stream<Object> envelopeStream = this.envelopes != null ? this.envelopes.stream() : this.envelopeStreamFromPaths(this.paths);
        return envelopeStream.flatMap(envelope -> this.parserMessageStream((Envelope)envelope, this.includeSource, this.includeAst, this.includePickles));
    }

    private Stream<Envelope> envelopeStreamFromPaths(List<String> paths) {
        return paths.stream().map(this::envelopeFromPath);
    }

    private Envelope envelopeFromPath(String path) {
        try {
            String data = Gherkin.read(new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8));
            return Gherkin.makeSourceEnvelope(data, path);
        }
        catch (IOException e) {
            throw new GherkinException(e.getMessage(), e);
        }
    }

    private static String read(Reader reader) throws IOException {
        int read;
        char[] buffer = new char[65536];
        StringBuilder sb = new StringBuilder();
        do {
            if ((read = reader.read(buffer, 0, buffer.length)) <= 0) continue;
            sb.append(buffer, 0, read);
        } while (read >= 0);
        return sb.toString();
    }

    private Stream<Envelope> parserMessageStream(Envelope envelope, boolean includeSource, boolean includeGherkinDocument, boolean includePickles) {
        ArrayList<Envelope> messages = new ArrayList<Envelope>();
        if (includeSource) {
            messages.add(envelope);
        }
        if (envelope.getSource() != null) {
            Parser<GherkinDocument> parser = new Parser<GherkinDocument>(new GherkinDocumentBuilder(this.idGenerator));
            Source source = envelope.getSource();
            String uri = source.getUri();
            String data = source.getData();
            try {
                GherkinDocument gherkinDocument = null;
                if (includeGherkinDocument) {
                    gherkinDocument = parser.parse(data);
                    gherkinDocument.setUri(uri);
                    Envelope gherkinDocumentEnvelope = new Envelope();
                    gherkinDocumentEnvelope.setGherkinDocument(gherkinDocument);
                    messages.add(gherkinDocumentEnvelope);
                }
                if (includePickles) {
                    if (gherkinDocument == null) {
                        gherkinDocument = parser.parse(data);
                        gherkinDocument.setUri(uri);
                    }
                    PickleCompiler pickleCompiler = new PickleCompiler(this.idGenerator);
                    List<Pickle> pickles = pickleCompiler.compile(gherkinDocument, uri);
                    for (Pickle pickle : pickles) {
                        Envelope pickleEnvelope = new Envelope();
                        pickleEnvelope.setPickle(pickle);
                        messages.add(pickleEnvelope);
                    }
                }
            }
            catch (ParserException.CompositeParserException e) {
                for (ParserException error : e.errors) {
                    this.addParseError(messages, error, uri);
                }
            }
            catch (ParserException e) {
                this.addParseError(messages, e, uri);
            }
        }
        return messages.stream();
    }

    private void addParseError(List<Envelope> messages, ParserException e, String uri) {
        long line = e.location.getLine();
        long column = e.location.getColumn();
        ParseError parseError = new ParseError(new SourceReference(uri, null, null, new Location(line == 0L ? null : Long.valueOf(line), column == 0L ? null : Long.valueOf(column))), e.getMessage());
        Envelope envelope = new Envelope();
        envelope.setParseError(parseError);
        messages.add(envelope);
    }
}

