/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details.executable;

import java.awt.Color;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Executable;

public class LogMessageDisplay {
    private Executable executable;
    private Color color;
    private final float fontsize = 9.0f;

    public AbstractCell display() {
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        ParagraphCell.Paragraph.ParagraphBuilder paragraphBuilder = ParagraphCell.Paragraph.builder();
        boolean started = true;
        for (String log : this.executable.getOutput()) {
            if (started) {
                started = false;
            } else {
                paragraphBuilder.appendNewLine();
            }
            paragraphBuilder.append(StyledText.builder().font(ReportFont.REGULAR_FONT).fontSize(Float.valueOf(9.0f)).text(sanitizer.sanitizeText(log)).color(this.color).build());
        }
        String message = sanitizer.getStripMessage();
        if (!message.isEmpty()) {
            paragraphBuilder.appendNewLine().append(StyledText.builder().font(ReportFont.REGULAR_FONT).fontSize(Float.valueOf(9.0f)).text(message).color(this.color).build());
        }
        return ((ParagraphCell.ParagraphCellBuilder)((ParagraphCell.ParagraphCellBuilder)ParagraphCell.builder().paragraph(paragraphBuilder.build()).borderColor(Color.GRAY)).borderWidth(1.0f)).lineSpacing(1.2f).build();
    }

    LogMessageDisplay(Executable executable, Color color) {
        this.executable = executable;
        this.color = color;
    }

    public static LogMessageDisplayBuilder builder() {
        return new LogMessageDisplayBuilder();
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public static class LogMessageDisplayBuilder {
        private Executable executable;
        private Color color;

        LogMessageDisplayBuilder() {
        }

        public LogMessageDisplayBuilder executable(Executable executable) {
            this.executable = executable;
            return this;
        }

        public LogMessageDisplayBuilder color(Color color) {
            this.color = color;
            return this;
        }

        public LogMessageDisplay build() {
            return new LogMessageDisplay(this.executable, this.color);
        }

        public String toString() {
            return "LogMessageDisplay.LogMessageDisplayBuilder(executable=" + this.executable + ", color=" + this.color + ")";
        }
    }
}

