/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.dashboard;

import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.DialStyler;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;
import tech.grasshopper.pdf.chart.ReportDialChart;
import tech.grasshopper.pdf.config.SummaryConfig;
import tech.grasshopper.pdf.data.SummaryData;
import tech.grasshopper.pdf.image.ImageCreator;
import tech.grasshopper.pdf.section.dashboard.DashboardDisplayUtil;
import tech.grasshopper.pdf.structure.Display;
import tech.grasshopper.pdf.util.NumberUtil;

public class DashboardDialDisplay
extends Display {
    private Table.TableBuilder tableBuilder;
    private final SummaryConfig summaryConfig;
    private final SummaryData summaryData;

    @Override
    public void display() {
        PDImageXObject featuresDial = this.createDialChart(NumberUtil.divideAndRound(this.summaryData.getPassedFeatures(), this.summaryData.getTotalFeatures()), NumberUtil.divideToPercent(this.summaryData.getPassedFeatures(), this.summaryData.getTotalFeatures()), this.summaryConfig.getDial().featureRange());
        PDImageXObject scenariosDial = this.createDialChart(NumberUtil.divideAndRound(this.summaryData.getPassedScenarios(), this.summaryData.getTotalScenarios()), NumberUtil.divideToPercent(this.summaryData.getPassedScenarios(), this.summaryData.getTotalScenarios()), this.summaryConfig.getDial().scenarioRange());
        PDImageXObject stepsDial = this.createDialChart(NumberUtil.divideAndRound(this.summaryData.getPassedSteps(), this.summaryData.getTotalSteps()), NumberUtil.divideToPercent(this.summaryData.getPassedSteps(), this.summaryData.getTotalSteps()), this.summaryConfig.getDial().stepRange());
        this.tableBuilder.addRow(Row.builder().add((AbstractCell)ImageCell.builder().image(featuresDial).build()).add((AbstractCell)DashboardDisplayUtil.spacerCell()).add((AbstractCell)ImageCell.builder().image(scenariosDial).build()).add((AbstractCell)DashboardDisplayUtil.spacerCell()).add((AbstractCell)ImageCell.builder().image(stepsDial).build()).build()).addRow(DashboardDisplayUtil.spacerRow());
    }

    private PDImageXObject createDialChart(double dialValue, int dialDisplay, double[] range) {
        ReportDialChart chart = new ReportDialChart(150, 150);
        this.updateDialChartStyler((DialStyler)chart.getStyler(), range);
        chart.updateData("Pass %", dialValue, dialDisplay);
        return ImageCreator.builder().chart((Chart<?, ?>)chart).document(this.document).build().generateChartImageXObject();
    }

    private void updateDialChartStyler(DialStyler styler, double[] range) {
        styler.setGreenColor(this.reportConfig.getSummaryConfig().getDial().badColor());
        styler.setGreenFrom(0.0);
        styler.setGreenTo(range[0]);
        styler.setNormalColor(this.reportConfig.getSummaryConfig().getDial().averageColor());
        styler.setNormalFrom(range[0]);
        styler.setNormalTo(range[1]);
        styler.setRedColor(this.reportConfig.getSummaryConfig().getDial().goodColor());
        styler.setRedFrom(range[1]);
        styler.setRedTo(1.0);
    }

    protected DashboardDialDisplay(DashboardDialDisplayBuilder<?, ?> b) {
        super(b);
        this.summaryConfig = this.reportConfig.getSummaryConfig();
        this.summaryData = (SummaryData)this.displayData;
        this.tableBuilder = ((DashboardDialDisplayBuilder)b).tableBuilder;
    }

    public static DashboardDialDisplayBuilder<?, ?> builder() {
        return new DashboardDialDisplayBuilderImpl();
    }

    void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    private static final class DashboardDialDisplayBuilderImpl
    extends DashboardDialDisplayBuilder<DashboardDialDisplay, DashboardDialDisplayBuilderImpl> {
        private DashboardDialDisplayBuilderImpl() {
        }

        @Override
        protected DashboardDialDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public DashboardDialDisplay build() {
            return new DashboardDialDisplay(this);
        }
    }

    public static abstract class DashboardDialDisplayBuilder<C extends DashboardDialDisplay, B extends DashboardDialDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private Table.TableBuilder tableBuilder;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DashboardDialDisplay.DashboardDialDisplayBuilder(super=" + super.toString() + ", tableBuilder=" + this.tableBuilder + ")";
        }
    }
}

