/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.pojo.cucumber;

import java.util.ArrayList;
import java.util.List;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.pojo.cucumber.Hook;
import tech.grasshopper.pdf.pojo.cucumber.Row;
import tech.grasshopper.pdf.section.details.executable.ExecutableDisplay;
import tech.grasshopper.pdf.section.details.executable.StepDisplay;

public class Step
extends Executable {
    private String keyword;
    private List<Row> rows;
    private String docString;
    private List<Hook> before;
    private List<Hook> after;

    public List<Hook> getBeforeAfterHooks() {
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        hooks.addAll(this.before);
        hooks.addAll(this.after);
        return hooks;
    }

    public void addBeforeStepHook(Hook hook) {
        this.before.add(hook);
    }

    public void addAfterStepHook(Hook hook) {
        this.after.add(hook);
    }

    @Override
    public ExecutableDisplay getDisplay() {
        return ((StepDisplay.StepDisplayBuilder)StepDisplay.builder().executable(this)).build();
    }

    @Override
    public void checkData() {
        if (this.name == null || this.name.isEmpty()) {
            throw new PdfReportException("Step text is null or empty.");
        }
        if (this.keyword == null || this.keyword.isEmpty()) {
            throw new PdfReportException("Keyword is null or empty for step - " + this.getName());
        }
        if (this.status == null) {
            throw new PdfReportException("No status present for step - " + this.getName());
        }
        super.checkData();
    }

    private static List<Row> $default$rows() {
        return new ArrayList<Row>();
    }

    private static String $default$docString() {
        return "";
    }

    private static List<Hook> $default$before() {
        return new ArrayList<Hook>();
    }

    private static List<Hook> $default$after() {
        return new ArrayList<Hook>();
    }

    protected Step(StepBuilder<?, ?> b) {
        super((Executable.ExecutableBuilder<?, ?>)b);
        this.keyword = ((StepBuilder)b).keyword;
        this.rows = ((StepBuilder)b).rows$set ? ((StepBuilder)b).rows$value : Step.$default$rows();
        this.docString = ((StepBuilder)b).docString$set ? ((StepBuilder)b).docString$value : Step.$default$docString();
        this.before = ((StepBuilder)b).before$set ? ((StepBuilder)b).before$value : Step.$default$before();
        this.after = ((StepBuilder)b).after$set ? ((StepBuilder)b).after$value : Step.$default$after();
    }

    public static StepBuilder<?, ?> builder() {
        return new StepBuilderImpl();
    }

    public String getKeyword() {
        return this.keyword;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public String getDocString() {
        return this.docString;
    }

    public List<Hook> getBefore() {
        return this.before;
    }

    public List<Hook> getAfter() {
        return this.after;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public void setDocString(String docString) {
        this.docString = docString;
    }

    public void setBefore(List<Hook> before) {
        this.before = before;
    }

    public void setAfter(List<Hook> after) {
        this.after = after;
    }

    @Override
    public String toString() {
        return "Step(keyword=" + this.getKeyword() + ", rows=" + this.getRows() + ", docString=" + this.getDocString() + ", before=" + this.getBefore() + ", after=" + this.getAfter() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Step)) {
            return false;
        }
        Step other = (Step)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
            return false;
        }
        List<Row> this$rows = this.getRows();
        List<Row> other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        String this$docString = this.getDocString();
        String other$docString = other.getDocString();
        if (this$docString == null ? other$docString != null : !this$docString.equals(other$docString)) {
            return false;
        }
        List<Hook> this$before = this.getBefore();
        List<Hook> other$before = other.getBefore();
        if (this$before == null ? other$before != null : !((Object)this$before).equals(other$before)) {
            return false;
        }
        List<Hook> this$after = this.getAfter();
        List<Hook> other$after = other.getAfter();
        return !(this$after == null ? other$after != null : !((Object)this$after).equals(other$after));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Step;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        List<Row> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        String $docString = this.getDocString();
        result = result * 59 + ($docString == null ? 43 : $docString.hashCode());
        List<Hook> $before = this.getBefore();
        result = result * 59 + ($before == null ? 43 : ((Object)$before).hashCode());
        List<Hook> $after = this.getAfter();
        result = result * 59 + ($after == null ? 43 : ((Object)$after).hashCode());
        return result;
    }

    private static final class StepBuilderImpl
    extends StepBuilder<Step, StepBuilderImpl> {
        private StepBuilderImpl() {
        }

        @Override
        protected StepBuilderImpl self() {
            return this;
        }

        @Override
        public Step build() {
            return new Step(this);
        }
    }

    public static abstract class StepBuilder<C extends Step, B extends StepBuilder<C, B>>
    extends Executable.ExecutableBuilder<C, B> {
        private String keyword;
        private boolean rows$set;
        private List<Row> rows$value;
        private boolean docString$set;
        private String docString$value;
        private boolean before$set;
        private List<Hook> before$value;
        private boolean after$set;
        private List<Hook> after$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B keyword(String keyword) {
            this.keyword = keyword;
            return (B)this.self();
        }

        public B rows(List<Row> rows) {
            this.rows$value = rows;
            this.rows$set = true;
            return (B)this.self();
        }

        public B docString(String docString) {
            this.docString$value = docString;
            this.docString$set = true;
            return (B)this.self();
        }

        public B before(List<Hook> before) {
            this.before$value = before;
            this.before$set = true;
            return (B)this.self();
        }

        public B after(List<Hook> after) {
            this.after$value = after;
            this.after$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Step.StepBuilder(super=" + super.toString() + ", keyword=" + this.keyword + ", rows$value=" + this.rows$value + ", docString$value=" + this.docString$value + ", before$value=" + this.before$value + ", after$value=" + this.after$value + ")";
        }
    }
}

