/*
 * Decompiled with CFR 0.152.
 */
package tech.gaolinfeng.imagecrop.lib;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;

public abstract class ImageUtil {
    public static Bitmap toRoundBitmap(Bitmap bitmap) {
        float dst_bottom;
        float dst_right;
        float dst_top;
        float dst_left;
        float bottom;
        float right;
        float top;
        float left;
        float roundPx;
        int height;
        int width = bitmap.getWidth();
        if (width <= (height = bitmap.getHeight())) {
            roundPx = width / 2;
            left = 0.0f;
            top = 0.0f;
            right = width;
            bottom = width;
            height = width;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = width;
            dst_bottom = width;
        } else {
            float clip;
            roundPx = height / 2;
            left = clip = (float)((width - height) / 2);
            right = (float)width - clip;
            top = 0.0f;
            bottom = height;
            width = height;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = height;
            dst_bottom = height;
        }
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        Rect src = new Rect((int)left, (int)top, (int)right, (int)bottom);
        Rect dst = new Rect((int)dst_left, (int)dst_top, (int)dst_right, (int)dst_bottom);
        paint.setAntiAlias(true);
        paint.setColor(Color.parseColor((String)"#ffffffff"));
        canvas.drawCircle(roundPx, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, src, dst, paint);
        return output;
    }
}

