/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.loader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import tech.deplant.commons.SystemContext;
import tech.deplant.java4ever.binding.loader.LibraryLoader;

public record DefaultLoader(ClassLoader loader) implements LibraryLoader
{
    public static final String EVER_SDK_VERSION = "1.45.0";
    public static final String BINDING_LIBRARY_NAME = "java4ever";
    public static final String BINDING_LIBRARY_VERSION = "3.0.0";
    private static final System.Logger logger = System.getLogger(DefaultLoader.class.getName());

    public static String resourceToAbsolute(ClassLoader loader, String resourcePath) throws IOException {
        URL url = loader.getResource(resourcePath);
        File lib = null;
        if (url.getProtocol().toLowerCase().equals("file")) {
            try {
                lib = new File(new URI(url.toString()));
            }
            catch (URISyntaxException e) {
                lib = new File(url.getPath());
            }
            File finalLib = lib;
            logger.log(System.Logger.Level.DEBUG, () -> "Looking in %s".formatted(finalLib.getAbsolutePath()));
            if (!lib.exists()) {
                throw new IOException("File URL " + String.valueOf(url) + " could not be properly decoded");
            }
        }
        return lib.getAbsolutePath();
    }

    private InputStream getLibraryResource(String name) {
        return this.loader().getResourceAsStream(name);
    }

    public void loadJarDll(String name) {
        try {
            InputStream in = this.getLibraryResource(name);
            Objects.requireNonNull(in, "EVER-SDK library file not found or can't be accessed. You can also try other LibraryLoader variants.");
            byte[] buffer = new byte[1024];
            int read = -1;
            File temp = null;
            temp = File.createTempFile(name, "");
            FileOutputStream fos = new FileOutputStream(temp);
            while ((read = in.read(buffer)) != -1) {
                fos.write(buffer, 0, read);
            }
            fos.close();
            in.close();
            System.load(temp.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void load() {
        if (SystemContext.OS().equals((Object)SystemContext.OperatingSystem.WINDOWS) && SystemContext.PROCESSOR().equals((Object)SystemContext.ProcessorArchitecture.X86_64)) {
            this.loadJarDll("sdk/win_x86_64/ton_client.dll");
        } else if (SystemContext.OS().equals((Object)SystemContext.OperatingSystem.LINUX) && SystemContext.PROCESSOR().equals((Object)SystemContext.ProcessorArchitecture.X86_64)) {
            this.loadJarDll("sdk/linux_x86_64/libton_client.so");
        } else if (SystemContext.OS().equals((Object)SystemContext.OperatingSystem.MAC) && SystemContext.PROCESSOR().equals((Object)SystemContext.ProcessorArchitecture.X86_64)) {
            this.loadJarDll("sdk/macos_x86_64/libton_client.dylib");
        } else if (SystemContext.OS().equals((Object)SystemContext.OperatingSystem.MAC) && SystemContext.PROCESSOR().equals((Object)SystemContext.ProcessorArchitecture.ARM_64)) {
            this.loadJarDll("sdk/macos_aarch64/libton_client.dylib");
        } else {
            throw new RuntimeException("Unsupported architecture, use other loaders for your custom EVER-SDK library!");
        }
    }
}

