/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.io;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import java.util.function.Supplier;
import tech.deplant.java4ever.binding.io.ByteResource;

public record JsonResource(String resourceName) implements Supplier<String>,
Consumer<String>
{
    @Override
    public String get() {
        return new String(new ByteResource(this.resourceName()).get(), StandardCharsets.UTF_8).replaceAll("[\u0000-\u001f]", "");
    }

    @Override
    public void accept(String jsonString) {
        try {
            Path path = Paths.get(this.resourceName, new String[0]).toAbsolutePath();
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.writeString(path, (CharSequence)jsonString, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

