/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.generator.jtype;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import tech.deplant.java4ever.binding.generator.ParserEngine;
import tech.deplant.java4ever.binding.generator.ParserUtils;
import tech.deplant.java4ever.binding.generator.TypeReference;
import tech.deplant.java4ever.binding.generator.jtype.SdkDocs;
import tech.deplant.java4ever.binding.generator.jtype.SdkDummy;
import tech.deplant.java4ever.binding.generator.jtype.SdkObject;
import tech.deplant.java4ever.binding.generator.reference.ApiType;
import tech.deplant.javapoet.AnnotationSpec;
import tech.deplant.javapoet.ParameterSpec;
import tech.deplant.javapoet.TypeName;

public record SdkParam(TypeName refClassName, String parameterName, String origParamName, boolean hasReserved, String summary, String description, SdkObject libType, Map<ParserEngine.SdkType, SdkObject> typeLibrary) {
    public static final Map<String, String> RESERVED_FIELD_NAMES = Map.of("public", "public_key", "secret", "secret_key", "switch", "switch_to", "ABI version", "abi_version_major");

    public static SdkParam ofApiType(ApiType paramType, Map<ParserEngine.SdkType, SdkObject> typeLibrary) {
        TypeName className;
        TypeReference typeReference = TypeReference.fromApiType(paramType);
        SdkObject javaType = typeReference.toTypeDeclaration(typeLibrary);
        String paramName = "";
        String reservedName = "";
        boolean hasReserved = false;
        if (javaType instanceof SdkDummy) {
            SdkDummy dummy = (SdkDummy)javaType;
            className = TypeReference.fromApiType(dummy.type()).toTypeName(typeLibrary);
        } else {
            className = typeReference.toTypeName(typeLibrary);
        }
        paramName = "Context".equals(className.toString()) ? "ctx" : paramType.name();
        if (Objects.nonNull(paramName)) {
            reservedName = RESERVED_FIELD_NAMES.getOrDefault(paramName, paramName);
            hasReserved = !reservedName.equals(paramName);
        }
        return new SdkParam(className, ParserUtils.camelCase(reservedName), paramName, hasReserved, paramType.summary(), paramType.description(), typeReference.toTypeDeclaration(typeLibrary), typeLibrary);
    }

    public static AnnotationSpec renamedFieldAnnotation(String originalName) {
        return AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{originalName}).build();
    }

    public ParameterSpec.Builder poeticize() {
        ParameterSpec.Builder componentBuilder = ParameterSpec.builder((TypeName)this.refClassName(), (String)this.parameterName(), (Modifier[])new Modifier[0]);
        if (this.hasReserved()) {
            componentBuilder.addAnnotation(SdkParam.renamedFieldAnnotation(this.origParamName()));
        }
        componentBuilder.addJavadoc(new SdkDocs(this.summary(), this.description()).poeticize().build());
        return componentBuilder;
    }
}

