/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import tech.deplant.java4ever.binding.AppObject;
import tech.deplant.java4ever.binding.Client;
import tech.deplant.java4ever.binding.Crypto;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;

public abstract class AppEncryptionBox
implements AppObject {
    @Override
    public final void consumeParams(int contextId, long appRequestId, JsonNode jsonNode) throws EverSdkException {
        try (ExecutorService exec = Executors.newVirtualThreadPerTaskExecutor();){
            exec.submit(() -> {
                block7: {
                    try {
                        String requestMethod = jsonNode.get("type").asText();
                        if ("GetInfo".equals(requestMethod)) {
                            Crypto.EncryptionBoxInfo encryptionBox = this.getInfo();
                            JsonNode resultNode = JsonContext.SDK_JSON_MAPPER().valueToTree((Object)new Crypto.ResultOfAppEncryptionBox.GetInfo(encryptionBox));
                            Client.resolveAppRequest(contextId, appRequestId, new Client.AppRequestResult.Ok(resultNode));
                            break block7;
                        }
                        if ("Encrypt".equals(requestMethod)) {
                            String encrypted = this.encrypt(jsonNode.get("data").asText());
                            JsonNode resultNode = JsonContext.SDK_JSON_MAPPER().valueToTree((Object)new Crypto.ResultOfAppEncryptionBox.Encrypt(encrypted));
                            Client.resolveAppRequest(contextId, appRequestId, new Client.AppRequestResult.Ok(resultNode));
                            break block7;
                        }
                        if ("Decrypt".equals(requestMethod)) {
                            String decrypted = this.decrypt(jsonNode.get("data").asText());
                            JsonNode resultNode = JsonContext.SDK_JSON_MAPPER().valueToTree((Object)new Crypto.ResultOfAppEncryptionBox.Decrypt(decrypted));
                            Client.resolveAppRequest(contextId, appRequestId, new Client.AppRequestResult.Ok(resultNode));
                            break block7;
                        }
                        throw new IllegalStateException("Unexpected value: " + jsonNode.get("type").asText());
                    }
                    catch (Exception e) {
                        try {
                            Client.resolveAppRequest(contextId, appRequestId, new Client.AppRequestResult.Error(e.getMessage()));
                        }
                        catch (EverSdkException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
            });
            exec.shutdown();
            if (!exec.awaitTermination(60L, TimeUnit.SECONDS)) {
                Client.resolveAppRequest(contextId, appRequestId, new Client.AppRequestResult.Error("Unsuccessful completion"));
            }
        }
        catch (Exception e) {
            Client.resolveAppRequest(contextId, appRequestId, new Client.AppRequestResult.Error(e.getMessage()));
        }
    }

    public abstract Crypto.EncryptionBoxInfo getInfo();

    public abstract String encrypt(String var1);

    public abstract String decrypt(String var1);
}

