/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.subscription;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import tech.deplant.java4ever.binding.EverSdk;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.binding.Net;
import tech.deplant.java4ever.framework.subscription.SubscriptionHandle;

public interface Subscriptions {
    public static Builder onAccounts(String ... outputFields) {
        return new Builder(SubscriptionType.ACCOUNTS, outputFields);
    }

    public static Builder onMessages(String ... outputFields) {
        return new Builder(SubscriptionType.MESSAGES, outputFields);
    }

    public static Builder onTransactions(String ... outputFields) {
        return new Builder(SubscriptionType.TRANSACTIONS, outputFields);
    }

    public static Builder onBlocks(String ... outputFields) {
        return new Builder(SubscriptionType.BLOCKS, outputFields);
    }

    public static Builder onBlocksSignatures(String ... outputFields) {
        return new Builder(SubscriptionType.BLOCKS_SIGNATURES, outputFields);
    }

    public static Builder onZeroStates(String ... outputFields) {
        return new Builder(SubscriptionType.ZEROSTATES, outputFields);
    }

    public static Builder onCounterparties(String ... outputFields) {
        return new Builder(SubscriptionType.COUNTERPARTIES, outputFields);
    }

    public static Builder onRempReceipts(String ... outputFields) {
        return new Builder(SubscriptionType.REMP_RECEIMPTS, outputFields);
    }

    public int contextId();

    public long handle();

    public boolean isCallbackToQueue();

    public Deque<JsonNode> callbackQueue();

    public static class Builder {
        private final Set<Predicate<JsonNode>> consumeFilters = new HashSet<Predicate<JsonNode>>();
        private final Set<Consumer<JsonNode>> consumers = new HashSet<Consumer<JsonNode>>();
        private String queryText;
        private boolean hasUnsubsribeCondition = false;
        private Predicate<JsonNode> unsubscribeCondition;
        private long handle;
        private boolean isCallbackToQueue = false;
        private boolean hasGqlFilter = false;
        private Set<String> gqlFilters = new HashSet<String>();

        private Builder(SubscriptionType type, String ... outputFields) {
            String text = "subscription {\n\t\t\t<TYPE>(\n\t\t\t   <FILTER>\n                ) {\n              <OUTPUT>\n\t\t\t}\n\t\t}\n";
            switch (type.ordinal()) {
                case 0: {
                    text = text.replace("<TYPE>", "accounts");
                    break;
                }
                case 1: {
                    text = text.replace("<TYPE>", "transactions");
                    break;
                }
                case 2: {
                    text = text.replace("<TYPE>", "messages");
                    break;
                }
                case 3: {
                    text = text.replace("<TYPE>", "blocks");
                    break;
                }
                case 4: {
                    text = text.replace("<TYPE>", "blocks_signatures");
                    break;
                }
                case 5: {
                    text = text.replace("<TYPE>", "zerostates");
                    break;
                }
                case 6: {
                    text = text.replace("<TYPE>", "counterparties");
                    break;
                }
                case 7: {
                    text = text.replace("<TYPE>", "rempReceipts");
                }
            }
            this.queryText = text = text.replace("<OUTPUT>", String.join((CharSequence)" ", outputFields));
        }

        private Builder() {
        }

        public Builder addCallbackConsumer(Consumer<JsonNode> callbackConsumer) {
            this.consumers.add(callbackConsumer);
            return this;
        }

        public Builder setCallbackToQueue(boolean doCallbackToQueue) {
            this.isCallbackToQueue = doCallbackToQueue;
            return this;
        }

        public Builder addFilterOnSubscription(String gqlFilter) {
            this.hasGqlFilter = true;
            this.gqlFilters.add(gqlFilter);
            return this;
        }

        public Builder addFilterOnConsume(Predicate<JsonNode> javaFilter) {
            this.consumeFilters.add(javaFilter);
            return this;
        }

        private String constructQuery() {
            String finalQuery = this.queryText.replace("<FILTER>", String.join((CharSequence)" ", (CharSequence[])this.gqlFilters.toArray(String[]::new)));
            finalQuery = finalQuery.replace("<OUTPUT>", "");
            return finalQuery;
        }

        private SubscriptionHandle subscribe(int contextId) throws EverSdkException {
            SubscriptionHandle subscription = new SubscriptionHandle(contextId, this.constructQuery(), this.hasUnsubsribeCondition, this.unsubscribeCondition, this.consumeFilters, this.consumers, this.isCallbackToQueue);
            Consumer<JsonNode> rootConsumer = eventJson -> {
                if (subscription.testConsumeFilters((JsonNode)eventJson)) {
                    if (subscription.hasUnsubsribeCondition() && subscription.unsubscribeCondition().test((JsonNode)eventJson)) {
                        subscription.unsubscribe();
                    }
                    subscription.broadcastToConsumers((JsonNode)eventJson);
                    if (subscription.isCallbackToQueue()) {
                        subscription.callbackQueue().add((JsonNode)eventJson);
                    }
                }
            };
            subscription.handle = ((Net.ResultOfSubscribeCollection)EverSdk.await((CompletableFuture)Net.subscribe((int)contextId, (String)subscription.queryText(), (JsonNode)JsonContext.EMPTY_NODE(), rootConsumer))).handle();
            return subscription;
        }

        public SubscriptionHandle subscribeUntilCancel(int contextId) throws EverSdkException {
            this.hasUnsubsribeCondition = false;
            return this.subscribe(contextId);
        }

        public SubscriptionHandle subscribeUntilFirst(int contextId) throws EverSdkException {
            this.hasUnsubsribeCondition = true;
            this.unsubscribeCondition = jsonNode -> true;
            return this.subscribe(contextId);
        }

        public SubscriptionHandle subscribeUntilCondition(int contextId, Predicate<JsonNode> unsubscribeCondition) throws EverSdkException {
            this.hasUnsubsribeCondition = true;
            this.unsubscribeCondition = unsubscribeCondition;
            return this.subscribe(contextId);
        }
    }

    public static enum SubscriptionType {
        ACCOUNTS,
        TRANSACTIONS,
        MESSAGES,
        BLOCKS,
        BLOCKS_SIGNATURES,
        ZEROSTATES,
        COUNTERPARTIES,
        REMP_RECEIMPTS;

    }
}

