/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.contract;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import tech.deplant.commons.Objs;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.FunctionHandle;
import tech.deplant.java4ever.framework.contract.Contract;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.subscription.Subscriptions;

public class AbstractContract
implements Contract {
    private final int contextId;
    private final Address address;
    private final ContractAbi abi;
    private Abi.Signer signer;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public AbstractContract(@JsonProperty(value="contextId") int contextId, @JsonProperty(value="address") Address address, @JsonProperty(value="abi") ContractAbi abi, @JsonProperty(value="credentials") Credentials credentials) {
        this(contextId, address, abi, (Abi.Signer)Objs.notNullReplaceElse((Object)credentials, (Object)credentials.signer(), (Object)new Abi.Signer.None()));
    }

    public AbstractContract(@JsonProperty(value="contextId") int contextId, @JsonProperty(value="address") String address, @JsonProperty(value="abi") ContractAbi abi, @JsonProperty(value="credentials") Credentials credentials) {
        this(contextId, new Address(address), abi, credentials);
    }

    public AbstractContract(int contextId, Address address, ContractAbi abi, Abi.Signer signer) {
        this.contextId = contextId;
        this.address = address;
        this.abi = abi;
        this.signer = signer;
    }

    public Subscriptions.Builder subscribeOnIncomingMessages(String resultFields, Consumer<JsonNode> subscribeEventConsumer) throws EverSdkException {
        return Subscriptions.onMessages(resultFields).addFilterOnSubscription("dst: { eq: \"%s\" }".formatted(this.address().toString())).addCallbackConsumer(subscribeEventConsumer);
    }

    public Subscriptions.Builder subscribeOnOutgoingMessages(String resultFields, Consumer<JsonNode> subscribeEventConsumer) throws EverSdkException {
        return Subscriptions.onMessages(resultFields).addFilterOnSubscription("src: { eq: \"%s\" }".formatted(this.address().toString())).addCallbackConsumer(subscribeEventConsumer);
    }

    public Subscriptions.Builder subscribeOnAccount(String resultFields, Consumer<JsonNode> subscribeEventConsumer) throws EverSdkException {
        return Subscriptions.onAccounts(resultFields).addFilterOnSubscription("id: { eq: \"%s\" }".formatted(this.address().toString())).addCallbackConsumer(subscribeEventConsumer);
    }

    public Subscriptions.Builder subscribeOnTransactions(Consumer<JsonNode> subscribeEventConsumer, String ... resultFields) throws EverSdkException {
        return Subscriptions.onAccounts(resultFields).addFilterOnSubscription("id: { eq: \"%s\" }".formatted(this.address().toString())).addCallbackConsumer(subscribeEventConsumer);
    }

    public FunctionHandle.Builder functionCallBuilder() {
        return new FunctionHandle.Builder(JsonNode.class).setContract(this);
    }

    @Override
    public int contextId() {
        return this.contextId;
    }

    @Override
    public Address address() {
        return this.address;
    }

    @Override
    public ContractAbi abi() {
        return this.abi;
    }

    @Override
    public Credentials credentials() {
        Abi.Signer signer = this.signer();
        Objects.requireNonNull(signer);
        Abi.Signer signer2 = signer;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Abi.Signer.SigningBox.class, Abi.Signer.Keys.class, Abi.Signer.External.class, Abi.Signer.None.class}, (Object)signer2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> throw new UnsupportedOperationException("You can't get credentials for contract that use signing_box as a signer.");
            case 1 -> {
                Abi.Signer.Keys keys = (Abi.Signer.Keys)signer2;
                yield new Credentials(keys.keys().publicKey(), keys.keys().secretKey());
            }
            case 2 -> {
                Abi.Signer.External ext = (Abi.Signer.External)signer2;
                throw new UnsupportedOperationException("You can't get credentials for contract that use external signer.");
            }
            case 3 -> Credentials.NONE;
        };
    }

    @Override
    public Abi.Signer signer() {
        return this.signer;
    }

    public int hashCode() {
        return Objects.hash(this.address(), this.abi(), this.credentials());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractContract)) {
            return false;
        }
        AbstractContract that = (AbstractContract)o;
        return Objects.equals(this.address(), that.address()) && Objects.equals(this.abi(), that.abi()) && Objects.equals(this.credentials(), that.credentials());
    }
}

