/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.contract;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.FunctionHandle;
import tech.deplant.java4ever.framework.SubscribeHandle;
import tech.deplant.java4ever.framework.contract.Contract;
import tech.deplant.java4ever.framework.datatype.Address;

public class AbstractContract
implements Contract {
    private final int contextId;
    private final Address address;
    private final ContractAbi abi;
    private Credentials credentials;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public AbstractContract(@JsonProperty(value="contextId") int contextId, @JsonProperty(value="address") Address address, @JsonProperty(value="abi") ContractAbi abi, @JsonProperty(value="credentials") Credentials credentials) {
        this.contextId = contextId;
        this.address = address;
        this.abi = abi;
        this.credentials = credentials;
    }

    public AbstractContract(@JsonProperty(value="contextId") int contextId, @JsonProperty(value="address") String address, @JsonProperty(value="abi") ContractAbi abi, @JsonProperty(value="credentials") Credentials credentials) {
        this.contextId = contextId;
        this.address = new Address(address);
        this.abi = abi;
        this.credentials = credentials;
    }

    public void waitForTransaction(Address from, boolean onlySuccessful, Runnable startEvent) throws EverSdkException, InterruptedException, TimeoutException {
        CompletableFuture futureSubscriptionResult = new CompletableFuture();
        new SubscribeHandle(this.contextId(), "subscription {\n\t\t\ttransactions(\n\t\t\t\t\tfilter: {\n\t\t\t\t\t\taccount_addr: { eq: \"%s\" }\n\t\t\t\t\t}\n                ) {\n\t\t\t\t%s\n\t\t\t}\n\t\t}\n".formatted(this.address(), "in_message { src } aborted status")).addEventConsumer(futureSubscriptionResult::complete).subscribe();
        startEvent.run();
        try {
            futureSubscriptionResult.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public SubscribeHandle subscribeOnIncomingMessages(String resultFields, Consumer<JsonNode> subscribeEventConsumer) throws EverSdkException {
        String queryText = "subscription {\n\t\t\tmessages(\n\t\t\t\t\tfilter: {\n\t\t\t\t\t\tdst: { eq: \"%s\" }\n\t\t\t\t\t}\n                ) {\n\t\t\t\t%s\n\t\t\t}\n\t\t}\n".formatted(this.address(), resultFields);
        return new SubscribeHandle(this.contextId(), queryText).addEventConsumer(subscribeEventConsumer).subscribe();
    }

    public SubscribeHandle subscribeOnOutgoingMessages(String resultFields, Consumer<JsonNode> subscribeEventConsumer) throws EverSdkException {
        String queryText = "subscription {\n\t\t\tmessages(\n\t\t\t\t\tfilter: {\n\t\t\t\t\t\tsrc: { eq: \"%s\" }\n\t\t\t\t\t}\n                ) {\n\t\t\t\t%s\n\t\t\t}\n\t\t}\n".formatted(this.address(), resultFields);
        return new SubscribeHandle(this.contextId(), queryText).addEventConsumer(subscribeEventConsumer).subscribe();
    }

    public SubscribeHandle subscribeOnAccount(String resultFields, Consumer<JsonNode> subscribeEventConsumer) throws EverSdkException {
        String queryText = "subscription {\n\t\t\taccounts(\n\t\t\t\t\tfilter: {\n\t\t\t\t\t\tid: { eq: \"%s\" }\n\t\t\t\t\t}\n                ) {\n\t\t\t\t%s\n\t\t\t}\n\t\t}\n".formatted(this.address(), resultFields);
        return new SubscribeHandle(this.contextId(), queryText).addEventConsumer(subscribeEventConsumer).subscribe();
    }

    public SubscribeHandle subscribeOnTransactions(String resultFields, Consumer<JsonNode> subscribeEventConsumer) throws EverSdkException {
        String queryText = "subscription {\n\t\t\ttransactions(\n\t\t\t\t\tfilter: {\n\t\t\t\t\t\taccount_addr: { eq: \"%s\" }\n\t\t\t\t\t}\n                ) {\n\t\t\t\t%s\n\t\t\t}\n\t\t}\n".formatted(this.address(), resultFields);
        return new SubscribeHandle(this.contextId(), queryText).addEventConsumer(subscribeEventConsumer).subscribe();
    }

    public FunctionHandle.Builder functionCallBuilder() {
        return new FunctionHandle.Builder(JsonNode.class).setContract(this);
    }

    @Override
    public int contextId() {
        return this.contextId;
    }

    @Override
    public Address address() {
        return this.address;
    }

    @Override
    public ContractAbi abi() {
        return this.abi;
    }

    @Override
    public Credentials credentials() {
        return this.credentials;
    }

    public int hashCode() {
        return Objects.hash(this.address(), this.abi(), this.credentials());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractContract)) {
            return false;
        }
        AbstractContract that = (AbstractContract)o;
        return Objects.equals(this.address(), that.address()) && Objects.equals(this.abi(), that.abi()) && Objects.equals(this.credentials(), that.credentials());
    }
}

