/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.datatype;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import tech.deplant.commons.Strings;
import tech.deplant.java4ever.binding.Boc;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.datatype.AbiType;
import tech.deplant.java4ever.framework.datatype.AbiTypePrefix;
import tech.deplant.java4ever.framework.datatype.AbiValue;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.SolBytes;
import tech.deplant.java4ever.framework.datatype.SolString;
import tech.deplant.java4ever.framework.datatype.TvmCell;
import tech.deplant.java4ever.framework.datatype.Uint;

public record TvmBuilder(AtomicInteger refCounter, List<Boc.BuilderOp> operations) implements AbiValue
{
    public TvmBuilder() {
        this(new AtomicInteger(0), new ArrayList<Boc.BuilderOp>());
    }

    public Boc.BuilderOp[] builders() {
        return (Boc.BuilderOp[])this.operations.toArray(Boc.BuilderOp[]::new);
    }

    public TvmBuilder store(AbiValue ... types) throws EverSdkException {
        for (AbiValue type : types) {
            AbiValue abiValue;
            Objects.requireNonNull(type);
            int n = 0;
            this.operations.add((Boc.BuilderOp)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Uint.class, Address.class, SolString.class, SolBytes.class, TvmBuilder.class}, (Object)abiValue, n)) {
                case 0 -> {
                    Uint intVal = (Uint)abiValue;
                    yield new Boc.BuilderOp.Integer(Long.valueOf(intVal.size()), intVal.toABI());
                }
                case 1 -> {
                    Address addr = (Address)abiValue;
                    yield new Boc.BuilderOp.Address(addr.toABI());
                }
                case 2 -> {
                    SolString str = (SolString)abiValue;
                    this.incrementRefCounter();
                    yield new Boc.BuilderOp.Cell(new Boc.BuilderOp[]{new Boc.BuilderOp.BitString(Strings.toHexString((String)str.toABI()))});
                }
                case 3 -> {
                    SolBytes byt = (SolBytes)abiValue;
                    this.incrementRefCounter();
                    yield new Boc.BuilderOp.Cell(new Boc.BuilderOp[]{new Boc.BuilderOp.BitString(byt.toABI())});
                }
                case 4 -> {
                    TvmBuilder builder = (TvmBuilder)abiValue;
                    this.incrementRefCounter();
                    yield new Boc.BuilderOp.Cell(builder.builders());
                }
                default -> throw new EverSdkException(new EverSdkException.ErrorResult(-305L, "Builder of TvmCell doesn't support this type for ABI conversion"), (Throwable)new Exception());
            }));
        }
        return this;
    }

    private void incrementRefCounter() throws EverSdkException {
        int refCount = this.refCounter.incrementAndGet();
        if (refCount > 4) {
            throw new EverSdkException(new EverSdkException.ErrorResult(-306L, "TvmCell can't contain more than 4 references to other TvmCells"));
        }
    }

    public TvmBuilder store(AbiType type, Object inputValue) throws EverSdkException {
        return this.store(AbiValue.of(type, inputValue));
    }

    public TvmCell toCell(Sdk sdk) throws EverSdkException {
        return new TvmCell(Boc.encodeBoc((EverSdkContext)sdk.context(), (Boc.BuilderOp[])this.builders(), null).boc());
    }

    public Object toJava() {
        return this;
    }

    @Override
    public Object toABI() {
        return this;
    }

    @Override
    public AbiType type() {
        return new AbiType(AbiTypePrefix.BUILDER, 0, false);
    }
}

