/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.generator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Modifier;
import tech.deplant.commons.Objs;
import tech.deplant.commons.Strings;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.binding.generator.ParserUtils;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.DeployHandle;
import tech.deplant.java4ever.framework.FunctionHandle;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.Tvc;
import tech.deplant.java4ever.framework.artifact.JsonResource;
import tech.deplant.java4ever.framework.contract.Contract;
import tech.deplant.java4ever.framework.datatype.AbiType;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.Bool;
import tech.deplant.java4ever.framework.datatype.SolBytes;
import tech.deplant.java4ever.framework.datatype.SolString;
import tech.deplant.java4ever.framework.datatype.TvmBuilder;
import tech.deplant.java4ever.framework.datatype.TvmCell;
import tech.deplant.java4ever.framework.datatype.Uint;
import tech.deplant.java4ever.framework.generator.GeneratorConfig;
import tech.deplant.java4ever.framework.template.Template;
import tech.deplant.javapoet.ArrayTypeName;
import tech.deplant.javapoet.ClassName;
import tech.deplant.javapoet.CodeBlock;
import tech.deplant.javapoet.JavaFile;
import tech.deplant.javapoet.MethodSpec;
import tech.deplant.javapoet.ParameterSpec;
import tech.deplant.javapoet.ParameterizedTypeName;
import tech.deplant.javapoet.TypeName;
import tech.deplant.javapoet.TypeSpec;

public class ContractWrapper {
    private static System.Logger logger = System.getLogger(ContractWrapper.class.getName());

    private static TypeName typeSwitch(String abiTypeString) throws EverSdkException {
        ClassName resultTypeName;
        AbiType details = AbiType.of(abiTypeString);
        switch (details.prefix()) {
            default: {
                throw new MatchException(null, null);
            }
            case INT: 
            case UINT: {
                ClassName className = ClassName.get(Uint.class);
                break;
            }
            case STRING: {
                ClassName className = ClassName.get(SolString.class);
                break;
            }
            case BYTE: 
            case BYTES: {
                ClassName className = ClassName.get(SolBytes.class);
                break;
            }
            case ADDRESS: {
                ClassName className = ClassName.get(Address.class);
                break;
            }
            case BOOL: {
                ClassName className = ClassName.get(Bool.class);
                break;
            }
            case CELL: {
                ClassName className = ClassName.get(TvmCell.class);
                break;
            }
            case SLICE: {
                ClassName className = TypeName.STRING;
                break;
            }
            case BUILDER: {
                ClassName className = ClassName.get(TvmBuilder.class);
                break;
            }
            case TUPLE: {
                ClassName className = ParameterizedTypeName.get((ClassName)TypeName.MAP, (TypeName[])new TypeName[]{TypeName.STRING, TypeName.OBJECT});
                break;
            }
            case OPTIONAL: {
                ClassName className = resultTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{ContractWrapper.typeSwitch(abiTypeString)});
            }
        }
        if (details.isArray()) {
            resultTypeName = ArrayTypeName.of((TypeName)resultTypeName);
        }
        return resultTypeName;
    }

    private static TypeName toTypeName(String abiTypeString) throws EverSdkException {
        String typeStringPattern = "([a-zA-Z]+\\d{0,3}\\[?\\]?)";
        Pattern mapPattern = Pattern.compile("(map\\()" + typeStringPattern + "(,)" + typeStringPattern + "(\\))");
        boolean rootIsMap = false;
        boolean rootIsOptional = false;
        String rootTypeString = abiTypeString;
        String keyTypeString = null;
        String valueTypeString = null;
        Matcher matcher = mapPattern.matcher(rootTypeString);
        while (matcher.find()) {
            rootIsMap = true;
            keyTypeString = matcher.group(2);
            valueTypeString = matcher.group(4);
        }
        Pattern optionalPattern = Pattern.compile("(optional\\()" + typeStringPattern + "(\\))");
        Matcher optionalMatcher = optionalPattern.matcher(rootTypeString);
        while (optionalMatcher.find()) {
            rootIsOptional = true;
            valueTypeString = optionalMatcher.group(2);
        }
        if (rootIsMap) {
            return ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ContractWrapper.typeSwitch(keyTypeString), ContractWrapper.typeSwitch(valueTypeString)});
        }
        if (rootIsOptional) {
            return ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{ContractWrapper.typeSwitch(valueTypeString)});
        }
        return ContractWrapper.typeSwitch(abiTypeString);
    }

    public static void generateFromConfig(String resourcePath) throws IOException, EverSdkException {
        ObjectMapper mapper = JsonContext.ABI_JSON_MAPPER();
        GeneratorConfig config = (GeneratorConfig)mapper.readValue(new JsonResource(resourcePath).get(), GeneratorConfig.class);
        Path targetDirectory = Paths.get(config.targetDir(), new String[0]);
        String contractPackage = config.contractPkg();
        String templatePackage = config.templatePkg();
        for (GeneratorConfig.GeneratorContract contract : config.contractList()) {
            logger.log(System.Logger.Level.INFO, contract);
            Tvc tvc = Objs.isNull((Object)contract.tvc()) ? null : Tvc.ofResource(contract.tvc());
            ContractWrapper.generate((Abi.AbiContract)mapper.readValue(new JsonResource(contract.abi()).get(), Abi.AbiContract.class), tvc, targetDirectory, contract.name(), (String)Objs.notNullElse((Object)contract.contractPkg(), (Object)contractPackage), templatePackage, (Boolean)Objs.notNullElse((Object)contract.shareOutputs(), (Object)false), contract.interfaces());
        }
    }

    public static void generate(Abi.AbiContract abi, Tvc tvc, Path targetDirectory, String contractName, String wrapperPackage, String templatePackage, boolean externalOutputs, String[] superInterfaces) throws IOException, EverSdkException {
        boolean hasTvc = Objs.isNotNull((Object)tvc);
        String wrapperName = ParserUtils.capitalize((String)contractName);
        CodeBlock.Builder wrapperDocs = CodeBlock.builder().add(String.format("Java wrapper class for usage of <strong>%s</strong> contract for Everscale blockchain.\n", wrapperName), new Object[0]);
        CodeBlock.Builder templateDocs = CodeBlock.builder().add(String.format("Java template class for deploy of <strong>%s</strong> contract for Everscale blockchain.\n", wrapperName), new Object[0]);
        TypeSpec.Builder wrapperBuilder = TypeSpec.recordBuilder((String)wrapperName).addJavadoc(wrapperDocs.build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (Objs.isNull((Object)superInterfaces) || superInterfaces.length == 0) {
            wrapperBuilder.addSuperinterface(Contract.class);
        } else {
            for (String s : superInterfaces) {
                wrapperBuilder.addSuperinterface((TypeName)ClassName.bestGuess((String)s));
            }
        }
        wrapperBuilder.addRecordComponent(Sdk.class, "sdk");
        wrapperBuilder.addRecordComponent(String.class, "address");
        wrapperBuilder.addRecordComponent(ContractAbi.class, "abi");
        wrapperBuilder.addRecordComponent(Credentials.class, "credentials");
        wrapperBuilder.addMethod(MethodSpec.constructorBuilder().addStatement("this(sdk,address,DEFAULT_ABI(),Credentials.NONE)", new Object[0]).addParameter(Sdk.class, "sdk", new Modifier[0]).addParameter(String.class, "address", new Modifier[0]).addException(JsonProcessingException.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        wrapperBuilder.addMethod(MethodSpec.constructorBuilder().addStatement("this(sdk,address,abi,Credentials.NONE)", new Object[0]).addParameter(Sdk.class, "sdk", new Modifier[0]).addParameter(String.class, "address", new Modifier[0]).addParameter(ContractAbi.class, "abi", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        wrapperBuilder.addMethod(MethodSpec.constructorBuilder().addStatement("this(sdk,address,DEFAULT_ABI(),credentials)", new Object[0]).addParameter(Sdk.class, "sdk", new Modifier[0]).addParameter(String.class, "address", new Modifier[0]).addParameter(Credentials.class, "credentials", new Modifier[0]).addException(JsonProcessingException.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        TypeSpec.Builder templateBuilder = TypeSpec.recordBuilder((String)(wrapperName + "Template")).addSuperinterface(Template.class).addJavadoc(templateDocs.build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        templateBuilder.addRecordComponent(ContractAbi.class, "abi");
        templateBuilder.addRecordComponent(Tvc.class, "tvc");
        MethodSpec defaultAbiFunction = MethodSpec.methodBuilder((String)"DEFAULT_ABI").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.get(ContractAbi.class)).addException(JsonProcessingException.class).addStatement("return ContractAbi.ofString($S)", new Object[]{JsonContext.ABI_JSON_MAPPER().setSerializationInclusion(JsonInclude.Include.NON_NULL).writeValueAsString((Object)abi)}).build();
        wrapperBuilder.addMethod(defaultAbiFunction);
        templateBuilder.addMethod(defaultAbiFunction);
        MethodSpec.Builder tvcOnlyConstructorBuilder = MethodSpec.constructorBuilder();
        tvcOnlyConstructorBuilder.addStatement("this(DEFAULT_ABI(), tvc)", new Object[0]).addParameter(ParameterSpec.builder(Tvc.class, (String)"tvc", (Modifier[])new Modifier[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(JsonProcessingException.class);
        templateBuilder.addMethod(tvcOnlyConstructorBuilder.build());
        if (hasTvc) {
            templateBuilder.addMethod(MethodSpec.methodBuilder((String)"DEFAULT_TVC").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.get(Tvc.class)).addStatement("return Tvc.ofBase64String($S)", new Object[]{tvc.base64String()}).build());
            MethodSpec.Builder noArgsConstructorBuilder = MethodSpec.constructorBuilder();
            noArgsConstructorBuilder.addStatement("this(DEFAULT_ABI(),DEFAULT_TVC())", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(JsonProcessingException.class);
            templateBuilder.addMethod(noArgsConstructorBuilder.build());
        }
        for (Abi.AbiFunction func : abi.functions()) {
            ClassName handleParamTypeName;
            ClassName handleTypeName;
            MethodSpec.Builder methodBuilder = null;
            boolean isConstructor = Strings.notEmptyEquals((String)func.name(), (String)"constructor");
            if (isConstructor) {
                methodBuilder = MethodSpec.methodBuilder((String)"prepareDeploy");
                logger.log(System.Logger.Level.INFO, "constructor!");
                methodBuilder.addParameter(ParameterSpec.builder(Sdk.class, (String)"sdk", (Modifier[])new Modifier[0]).build());
                methodBuilder.addParameter(ParameterSpec.builder(Credentials.class, (String)"credentials", (Modifier[])new Modifier[0]).build());
                StringBuilder fieldsMapBuilder = new StringBuilder("$T initialDataFields = $T.of(");
                ArrayList<String> fieldsList = new ArrayList<String>();
                ArrayList<Object> fieldArgsList = new ArrayList<Object>();
                fieldArgsList.add(ParameterizedTypeName.get((ClassName)TypeName.MAP, (TypeName[])new TypeName[]{TypeName.STRING, TypeName.OBJECT}));
                fieldArgsList.add(TypeName.MAP);
                if (Objs.isNotNull((Object)abi.data())) {
                    for (Abi.AbiData field : abi.data()) {
                        TypeName typeName = ContractWrapper.toTypeName(field.type());
                        ParameterSpec paramSpec = ParameterSpec.builder((TypeName)typeName, (String)field.name(), (Modifier[])new Modifier[0]).build();
                        methodBuilder.addParameter(paramSpec);
                        fieldsList.add("$S, $N");
                        fieldArgsList.add(field.name());
                        fieldArgsList.add(paramSpec);
                    }
                }
                fieldsMapBuilder.append(String.join((CharSequence)", \n", fieldsList));
                fieldsMapBuilder.append(")");
                CodeBlock.Builder bodyBuilder = CodeBlock.builder();
                bodyBuilder.addStatement(fieldsMapBuilder.toString(), fieldArgsList.toArray());
                methodBuilder.addCode(bodyBuilder.build());
            } else {
                methodBuilder = MethodSpec.methodBuilder((String)func.name());
            }
            logger.log(System.Logger.Level.INFO, func.name());
            methodBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
            StringBuilder mapStringBuilder = new StringBuilder("$T params = $T.of(");
            ArrayList<String> mapParams = new ArrayList<String>();
            ArrayList<Object> mapArgsBuilder = new ArrayList<Object>();
            mapArgsBuilder.add(ParameterizedTypeName.get((ClassName)TypeName.MAP, (TypeName[])new TypeName[]{TypeName.STRING, TypeName.OBJECT}));
            mapArgsBuilder.add(TypeName.MAP);
            TypeSpec resultOfFunctionType = null;
            if (func.outputs().length > 0) {
                TypeSpec.Builder resultTypeBuilder = TypeSpec.recordBuilder((String)("ResultOf" + ParserUtils.capitalize((String)func.name()))).addModifiers(new Modifier[]{Modifier.PUBLIC});
                for (Abi.AbiParam param : func.outputs()) {
                    TypeName resultTypeName = ContractWrapper.toTypeName(param.type());
                    ParameterSpec paramSpec = ParameterSpec.builder((TypeName)resultTypeName, (String)param.name(), (Modifier[])new Modifier[0]).build();
                    resultTypeBuilder.addRecordComponent(paramSpec);
                }
                resultOfFunctionType = resultTypeBuilder.build();
                if (externalOutputs) {
                    JavaFile outputTypeFile = JavaFile.builder((String)wrapperPackage, (TypeSpec)resultOfFunctionType).build();
                    outputTypeFile.writeTo(targetDirectory);
                } else {
                    wrapperBuilder.addType(resultOfFunctionType);
                }
            }
            for (Abi.AbiParam param : func.inputs()) {
                if (param.name().equals("answerId")) {
                    mapParams.add("\"answerId\", 0");
                    continue;
                }
                TypeName typeName = ContractWrapper.toTypeName(param.type());
                ParameterSpec paramSpec = ParameterSpec.builder((TypeName)typeName, (String)param.name(), (Modifier[])new Modifier[0]).build();
                methodBuilder.addParameter(paramSpec);
                mapParams.add("$S, $N");
                mapArgsBuilder.add(param.name());
                mapArgsBuilder.add(paramSpec);
            }
            mapStringBuilder.append(String.join((CharSequence)", \n", mapParams));
            mapStringBuilder.append(")");
            CodeBlock.Builder bodyBuilder = CodeBlock.builder();
            bodyBuilder.addStatement(mapStringBuilder.toString(), mapArgsBuilder.toArray());
            if (isConstructor) {
                handleTypeName = ClassName.get(DeployHandle.class);
                handleParamTypeName = ClassName.get((String)wrapperPackage, (String)wrapperName, (String[])new String[0]);
            } else {
                handleTypeName = ClassName.get(FunctionHandle.class);
                handleParamTypeName = Objs.isNull((Object)resultOfFunctionType) ? ClassName.get(Void.class) : ClassName.bestGuess((String)resultOfFunctionType.name);
            }
            ParameterizedTypeName resultName = ParameterizedTypeName.get((ClassName)handleTypeName, (TypeName[])new TypeName[]{handleParamTypeName});
            methodBuilder.returns((TypeName)resultName);
            if (isConstructor) {
                bodyBuilder.addStatement("return new $T($T.class, sdk, abi(), tvc(), sdk.clientConfig().abi().workchain(), credentials, initialDataFields, params, null)", new Object[]{resultName, handleParamTypeName});
                methodBuilder.addCode(bodyBuilder.build());
                templateBuilder.addMethod(methodBuilder.build());
                continue;
            }
            bodyBuilder.addStatement("return new $T($T.class, sdk(), address(), abi(), credentials(), $S, params, null)", new Object[]{resultName, handleParamTypeName, func.name()});
            methodBuilder.addCode(bodyBuilder.build());
            wrapperBuilder.addMethod(methodBuilder.build());
        }
        JavaFile contractFile = JavaFile.builder((String)wrapperPackage, (TypeSpec)wrapperBuilder.build()).build();
        contractFile.writeTo(targetDirectory);
        JavaFile templateFile = JavaFile.builder((String)templatePackage, (TypeSpec)templateBuilder.build()).build();
        templateFile.writeTo(targetDirectory);
    }
}

