/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.contract;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigInteger;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.FunctionHandle;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.contract.Giver;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.TvmCell;
import tech.deplant.java4ever.framework.template.SafeMultisigWalletTemplate;
import tech.deplant.java4ever.framework.template.SetcodeMultisigWalletTemplate;
import tech.deplant.java4ever.framework.template.SurfMultisigWalletTemplate;

public interface MultisigWallet
extends Giver {
    @Override
    default public FunctionHandle<Void> give(String to, BigInteger value) {
        return this.sendTransaction(new Address(to), value, false, 1, TvmCell.EMPTY());
    }

    public FunctionHandle<Void> sendTransaction(Address var1, BigInteger var2, Boolean var3, Integer var4, TvmCell var5);

    public static MultisigWallet deploySingleSig(Type type, Sdk sdk, Giver giver, Credentials keys, BigInteger value) throws JsonProcessingException, EverSdkException {
        return MultisigWallet.deployMultiSig(type, sdk, giver, keys, value, 1, keys.publicBigInt());
    }

    public static MultisigWallet deployMultiSig(Type type, Sdk sdk, Giver giver, Credentials keys, BigInteger value, int confirmations, BigInteger ... publicKeys) throws JsonProcessingException, EverSdkException {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.SURF -> new SurfMultisigWalletTemplate().prepareDeploy(sdk, keys, publicKeys, confirmations).deployWithGiver(giver, value);
            case Type.SAFE -> new SafeMultisigWalletTemplate().prepareDeploy(sdk, keys, publicKeys, confirmations).deployWithGiver(giver, value);
            case Type.SETCODE -> new SetcodeMultisigWalletTemplate().prepareDeploy(sdk, keys, publicKeys, confirmations).deployWithGiver(giver, value);
        };
    }

    public static enum Type {
        SURF,
        SAFE,
        SETCODE;

    }
}

