/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.contract;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigInteger;
import java.util.Map;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.FunctionHandle;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.contract.MultisigWallet;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.TvmCell;

public record SafeMultisigWallet(Sdk sdk, String address, ContractAbi abi, Credentials credentials) implements MultisigWallet
{
    public SafeMultisigWallet(Sdk sdk, String address) throws JsonProcessingException {
        this(sdk, address, SafeMultisigWallet.DEFAULT_ABI(), Credentials.NONE);
    }

    public SafeMultisigWallet(Sdk sdk, String address, ContractAbi abi) {
        this(sdk, address, abi, Credentials.NONE);
    }

    public SafeMultisigWallet(Sdk sdk, String address, Credentials credentials) throws JsonProcessingException {
        this(sdk, address, SafeMultisigWallet.DEFAULT_ABI(), credentials);
    }

    public static ContractAbi DEFAULT_ABI() throws JsonProcessingException {
        return ContractAbi.ofString("{\"ABI version\":2,\"header\":[\"pubkey\",\"time\",\"expire\"],\"functions\":[{\"name\":\"constructor\",\"inputs\":[{\"name\":\"owners\",\"type\":\"uint256[]\"},{\"name\":\"reqConfirms\",\"type\":\"uint8\"}],\"outputs\":[]},{\"name\":\"acceptTransfer\",\"inputs\":[{\"name\":\"payload\",\"type\":\"bytes\"}],\"outputs\":[]},{\"name\":\"sendTransaction\",\"inputs\":[{\"name\":\"dest\",\"type\":\"address\"},{\"name\":\"value\",\"type\":\"uint128\"},{\"name\":\"bounce\",\"type\":\"bool\"},{\"name\":\"flags\",\"type\":\"uint8\"},{\"name\":\"payload\",\"type\":\"cell\"}],\"outputs\":[]},{\"name\":\"submitTransaction\",\"inputs\":[{\"name\":\"dest\",\"type\":\"address\"},{\"name\":\"value\",\"type\":\"uint128\"},{\"name\":\"bounce\",\"type\":\"bool\"},{\"name\":\"allBalance\",\"type\":\"bool\"},{\"name\":\"payload\",\"type\":\"cell\"}],\"outputs\":[{\"name\":\"transId\",\"type\":\"uint64\"}]},{\"name\":\"confirmTransaction\",\"inputs\":[{\"name\":\"transactionId\",\"type\":\"uint64\"}],\"outputs\":[]},{\"name\":\"isConfirmed\",\"inputs\":[{\"name\":\"mask\",\"type\":\"uint32\"},{\"name\":\"index\",\"type\":\"uint8\"}],\"outputs\":[{\"name\":\"confirmed\",\"type\":\"bool\"}]},{\"name\":\"getParameters\",\"inputs\":[],\"outputs\":[{\"name\":\"maxQueuedTransactions\",\"type\":\"uint8\"},{\"name\":\"maxCustodianCount\",\"type\":\"uint8\"},{\"name\":\"expirationTime\",\"type\":\"uint64\"},{\"name\":\"minValue\",\"type\":\"uint128\"},{\"name\":\"requiredTxnConfirms\",\"type\":\"uint8\"}]},{\"name\":\"getTransaction\",\"inputs\":[{\"name\":\"transactionId\",\"type\":\"uint64\"}],\"outputs\":[{\"name\":\"trans\",\"type\":\"tuple\",\"components\":[{\"name\":\"id\",\"type\":\"uint64\"},{\"name\":\"confirmationsMask\",\"type\":\"uint32\"},{\"name\":\"signsRequired\",\"type\":\"uint8\"},{\"name\":\"signsReceived\",\"type\":\"uint8\"},{\"name\":\"creator\",\"type\":\"uint256\"},{\"name\":\"index\",\"type\":\"uint8\"},{\"name\":\"dest\",\"type\":\"address\"},{\"name\":\"value\",\"type\":\"uint128\"},{\"name\":\"sendFlags\",\"type\":\"uint16\"},{\"name\":\"payload\",\"type\":\"cell\"},{\"name\":\"bounce\",\"type\":\"bool\"}]}]},{\"name\":\"getTransactions\",\"inputs\":[],\"outputs\":[{\"name\":\"transactions\",\"type\":\"tuple[]\",\"components\":[{\"name\":\"id\",\"type\":\"uint64\"},{\"name\":\"confirmationsMask\",\"type\":\"uint32\"},{\"name\":\"signsRequired\",\"type\":\"uint8\"},{\"name\":\"signsReceived\",\"type\":\"uint8\"},{\"name\":\"creator\",\"type\":\"uint256\"},{\"name\":\"index\",\"type\":\"uint8\"},{\"name\":\"dest\",\"type\":\"address\"},{\"name\":\"value\",\"type\":\"uint128\"},{\"name\":\"sendFlags\",\"type\":\"uint16\"},{\"name\":\"payload\",\"type\":\"cell\"},{\"name\":\"bounce\",\"type\":\"bool\"}]}]},{\"name\":\"getTransactionIds\",\"inputs\":[],\"outputs\":[{\"name\":\"ids\",\"type\":\"uint64[]\"}]},{\"name\":\"getCustodians\",\"inputs\":[],\"outputs\":[{\"name\":\"custodians\",\"type\":\"tuple[]\",\"components\":[{\"name\":\"index\",\"type\":\"uint8\"},{\"name\":\"pubkey\",\"type\":\"uint256\"}]}]}],\"events\":[{\"name\":\"TransferAccepted\",\"inputs\":[{\"name\":\"payload\",\"type\":\"bytes\"}]}],\"data\":[]}");
    }

    public FunctionHandle<Void> acceptTransfer(String payload) {
        Map<String, Object> params = Map.of("payload", payload);
        return new FunctionHandle<Void>(this.sdk(), this.address(), this.abi(), this.credentials(), "acceptTransfer", params, null);
    }

    @Override
    public FunctionHandle<Void> sendTransaction(Address dest, BigInteger value, Boolean bounce, Integer flags, TvmCell payload) {
        Map<String, Object> params = Map.of("dest", dest, "value", value, "bounce", bounce, "flags", flags, "payload", payload);
        return new FunctionHandle<Void>(this.sdk(), this.address(), this.abi(), this.credentials(), "sendTransaction", params, null);
    }

    public FunctionHandle<ResultOfSubmitTransaction> submitTransaction(Address dest, BigInteger value, Boolean bounce, Boolean allBalance, TvmCell payload) {
        Map<String, Object> params = Map.of("dest", dest, "value", value, "bounce", bounce, "allBalance", allBalance, "payload", payload);
        return new FunctionHandle<ResultOfSubmitTransaction>(this.sdk(), this.address(), this.abi(), this.credentials(), "submitTransaction", params, null);
    }

    public FunctionHandle<Void> confirmTransaction(Long transactionId) {
        Map<String, Object> params = Map.of("transactionId", transactionId);
        return new FunctionHandle<Void>(this.sdk(), this.address(), this.abi(), this.credentials(), "confirmTransaction", params, null);
    }

    public FunctionHandle<ResultOfIsConfirmed> isConfirmed(Integer mask, Integer index) {
        Map<String, Object> params = Map.of("mask", mask, "index", index);
        return new FunctionHandle<ResultOfIsConfirmed>(this.sdk(), this.address(), this.abi(), this.credentials(), "isConfirmed", params, null);
    }

    public FunctionHandle<ResultOfGetParameters> getParameters() {
        Map<String, Object> params = Map.of();
        return new FunctionHandle<ResultOfGetParameters>(this.sdk(), this.address(), this.abi(), this.credentials(), "getParameters", params, null);
    }

    public FunctionHandle<ResultOfGetTransaction> getTransaction(Long transactionId) {
        Map<String, Object> params = Map.of("transactionId", transactionId);
        return new FunctionHandle<ResultOfGetTransaction>(this.sdk(), this.address(), this.abi(), this.credentials(), "getTransaction", params, null);
    }

    public FunctionHandle<ResultOfGetTransactions> getTransactions() {
        Map<String, Object> params = Map.of();
        return new FunctionHandle<ResultOfGetTransactions>(this.sdk(), this.address(), this.abi(), this.credentials(), "getTransactions", params, null);
    }

    public FunctionHandle<ResultOfGetTransactionIds> getTransactionIds() {
        Map<String, Object> params = Map.of();
        return new FunctionHandle<ResultOfGetTransactionIds>(this.sdk(), this.address(), this.abi(), this.credentials(), "getTransactionIds", params, null);
    }

    public FunctionHandle<ResultOfGetCustodians> getCustodians() {
        Map<String, Object> params = Map.of();
        return new FunctionHandle<ResultOfGetCustodians>(this.sdk(), this.address(), this.abi(), this.credentials(), "getCustodians", params, null);
    }

    public record ResultOfGetCustodians(Map<String, Object>[] custodians) {
    }

    public record ResultOfGetTransactionIds(Long[] ids) {
    }

    public record ResultOfGetTransactions(Map<String, Object>[] transactions) {
    }

    public record ResultOfGetTransaction(Map<String, Object> trans) {
    }

    public record ResultOfGetParameters(Integer maxQueuedTransactions, Integer maxCustodianCount, Long expirationTime, BigInteger minValue, Integer requiredTxnConfirms) {
    }

    public record ResultOfIsConfirmed(Boolean confirmed) {
    }

    public record ResultOfSubmitTransaction(Long transId) {
    }
}

