/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tech.deplant.java4ever.binding.ContextBuilder;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.abi.ContractAbi;
import tech.deplant.java4ever.framework.artifact.JsonFile;
import tech.deplant.java4ever.framework.contract.OwnedContract;
import tech.deplant.java4ever.framework.crypto.Credentials;

public record ExplorerConfig(String serializationPath, Map<String, SavedContract> contracts, Map<String, Credentials> credentials) {
    private static System.Logger logger = System.getLogger(ExplorerConfig.class.getName());

    public static ExplorerConfig EMPTY(String serializationPath) throws IOException {
        ExplorerConfig config = new ExplorerConfig(serializationPath, new ConcurrentHashMap<String, SavedContract>(), new ConcurrentHashMap<String, Credentials>());
        config.sync();
        return config;
    }

    public static ExplorerConfig LOAD(String configFilePath) throws JsonProcessingException {
        ObjectMapper mapper = ContextBuilder.DEFAULT_MAPPER;
        return (ExplorerConfig)mapper.readValue(new JsonFile(configFilePath).get(), ExplorerConfig.class);
    }

    public Credentials keys(String keysName) {
        return this.credentials().get(keysName);
    }

    public String address(String contractName) {
        return this.contracts().get(contractName).address();
    }

    public ContractAbi abi(String contractName) throws JsonProcessingException {
        return ContractAbi.ofString(this.contracts().get(contractName).abiJson());
    }

    public OwnedContract contract(Sdk sdk, String contractName, String keysName) throws JsonProcessingException {
        return new OwnedContract(sdk, this.address(contractName), this.abi(contractName), this.keys(keysName));
    }

    public OwnedContract addContract(String name, OwnedContract contract) throws IOException {
        this.contracts().put(name, new SavedContract(contract.abi().json(), contract.address()));
        this.sync();
        return contract;
    }

    public Credentials addKeys(String name, Credentials keys) throws IOException {
        this.credentials().put(name, keys);
        this.sync();
        return keys;
    }

    public void sync() throws IOException {
        ObjectMapper mapper = ContextBuilder.DEFAULT_MAPPER;
        new JsonFile(this.serializationPath()).accept(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this));
    }

    public record SavedContract(String abiJson, String address) {
    }
}

