/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.template;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigInteger;
import java.util.Map;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.abi.ContractAbi;
import tech.deplant.java4ever.framework.contract.Giver;
import tech.deplant.java4ever.framework.contract.Msig;
import tech.deplant.java4ever.framework.contract.OwnedContract;
import tech.deplant.java4ever.framework.crypto.Credentials;
import tech.deplant.java4ever.framework.template.ContractTemplate;
import tech.deplant.java4ever.framework.template.ContractTvc;

public class MsigTemplate
extends ContractTemplate {
    public static final ContractTvc SAFE_MULTISIG_TVC = ContractTvc.ofResource("artifacts/multisig/SafeMultisigWallet.tvc");
    public static final ContractTvc SETCODE_MULTISIG_TVC = ContractTvc.ofResource("artifacts/multisig/SetcodeMultisigWallet.tvc");
    public static final ContractTvc SURF_MULTISIG_TVC = ContractTvc.ofResource("artifacts/multisig/SurfMultisigWallet.tvc");

    public MsigTemplate(ContractAbi abi, ContractTvc tvc) {
        super(abi, tvc);
    }

    public static ContractAbi SAFE_MULTISIG_ABI() throws JsonProcessingException {
        return ContractAbi.ofResource("artifacts/multisig/SafeMultisigWallet.abi.json");
    }

    public static ContractAbi SETCODE_MULTISIG_ABI() throws JsonProcessingException {
        return ContractAbi.ofResource("artifacts/multisig/SetcodeMultisigWallet.abi.json");
    }

    public static ContractAbi SURF_MULTISIG_ABI() throws JsonProcessingException {
        return ContractAbi.ofResource("artifacts/multisig/SurfMultisigWallet.abi.json");
    }

    public static MsigTemplate SAFE() throws JsonProcessingException {
        return new MsigTemplate(MsigTemplate.SAFE_MULTISIG_ABI(), SAFE_MULTISIG_TVC);
    }

    public static MsigTemplate SETCODE() throws JsonProcessingException {
        return new MsigTemplate(MsigTemplate.SETCODE_MULTISIG_ABI(), SETCODE_MULTISIG_TVC);
    }

    public static MsigTemplate SURF() throws JsonProcessingException {
        return new MsigTemplate(MsigTemplate.SURF_MULTISIG_ABI(), SURF_MULTISIG_TVC);
    }

    public ContractTemplate withUpdatedInitialData(Sdk sdk, String publicKey) throws EverSdkException {
        return super.withUpdatedInitialData(sdk, Map.of(), publicKey);
    }

    public Msig deploySingleSig(Sdk sdk, Credentials keys, Giver giver, BigInteger value) throws EverSdkException {
        Map<String, Object> params = Map.of("owners", new String[]{"0x" + keys.publicKey()}, "reqConfirms", 1);
        OwnedContract contract = super.deployWithGiver(sdk, giver, value, 0, null, keys, params);
        return new Msig(contract.sdk(), contract.address(), contract.credentials(), contract.abi());
    }

    public Msig deploy3of5(Sdk sdk, Credentials keys, Giver giver, BigInteger value, String pubkey2, String pubkey3, String pubkey4, String pubkey5) throws EverSdkException {
        Map<String, Object> params = Map.of("owners", new String[]{keys.publicKey(), pubkey2, pubkey3, pubkey4, pubkey5}, "reqConfirms", 1);
        OwnedContract contract = super.deployWithGiver(sdk, giver, value, 0, null, keys, params);
        return new Msig(contract);
    }
}

