/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.AppObject;
import tech.deplant.java4ever.binding.Boc;
import tech.deplant.java4ever.binding.Client;
import tech.deplant.java4ever.binding.Crypto;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.binding.Processing;
import tech.deplant.java4ever.binding.ffi.EverSdkContext;
import tech.deplant.java4ever.binding.ffi.NativeMethods;
import tech.deplant.java4ever.binding.loader.DefaultLoaderContext;
import tech.deplant.java4ever.binding.loader.LibraryLoader;

public class EverSdk {
    public static final String LOG_FORMAT = "CTX:%d REQ:%d FUNC:%s %s:%s";
    private static final System.Logger logger = System.getLogger(EverSdk.class.getName());
    private static final Map<Integer, EverSdkContext> contexts = new ConcurrentHashMap<Integer, EverSdkContext>();
    public static long timeout = 600000L;

    public static Client.ClientConfig contextConfig(int contextId) {
        return contexts.get(contextId).config();
    }

    public static long getDefaultWorkchainId(int contextId) {
        Client.AbiConfig abiConfig = EverSdk.contextConfig(contextId).abi();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Client.AbiConfig.class}, (Object)abiConfig, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Client.AbiConfig abiConfig = abiConfig;
                yield Objects.requireNonNullElse(abiConfig.workchain(), 0L);
            }
            case -1 -> 0L;
        };
    }

    public static void load() {
        EverSdk.load(DefaultLoaderContext.SINGLETON(ClassLoader.getSystemClassLoader()));
    }

    public static void load(LibraryLoader loader) {
        loader.load();
    }

    public static <P> CompletableFuture<Void> asyncVoid(int contextId, String functionName, P functionInputs) throws EverSdkException {
        return contexts.get(contextId).callAsync(functionName, functionInputs, Void.class, null, null);
    }

    public static <T, P> CompletableFuture<T> async(int contextId, String functionName, P functionInputs, Class<T> outputClass) throws EverSdkException {
        return contexts.get(contextId).callAsync(functionName, functionInputs, outputClass, null, null);
    }

    public static <T, P> CompletableFuture<T> asyncCallback(int contextId, String functionName, P functionInputs, Class<T> outputClass, Consumer<JsonNode> eventConsumer) throws EverSdkException {
        return contexts.get(contextId).callAsync(functionName, functionInputs, outputClass, eventConsumer, null);
    }

    public static <T, P> CompletableFuture<T> asyncAppObject(int contextId, String functionName, P functionInputs, Class<T> outputClass, AppObject appObject) throws EverSdkException {
        return contexts.get(contextId).callAsync(functionName, functionInputs, outputClass, null, appObject);
    }

    public static void destroy(int contextId) {
        NativeMethods.tcDestroyContext(contextId);
    }

    public static int createDefault() throws EverSdkException {
        return EverSdk.createWithJson("{}");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static int createWithEndpoint(String endpoint) throws EverSdkException {
        return EverSdk.createWithJson("{ \"network\":{ \"endpoints\": [\"%s\"] } }".formatted(endpoint));
    }

    public static int createWithConfig(Client.ClientConfig config) throws EverSdkException {
        Client.ClientConfig mergedConfig = new Client.ClientConfig(new Client.BindingConfig("java4ever", "3.0.0"), config.network(), config.crypto(), config.abi(), config.boc(), config.proofs(), config.localStoragePath());
        String resultString = "";
        try {
            String mergedJson = JsonContext.SDK_JSON_MAPPER().writeValueAsString((Object)mergedConfig);
            try {
                resultString = NativeMethods.tcCreateContext(mergedJson);
                ResultOfCreateContext createContextResponse = (ResultOfCreateContext)JsonContext.SDK_JSON_MAPPER().readValue(resultString, ResultOfCreateContext.class);
                Optional<Integer> contextId = Optional.ofNullable(createContextResponse.result());
                if (contextId.isEmpty() || contextId.get() < 1) {
                    logger.log(System.Logger.Level.ERROR, () -> "FUNC:sdk.tc_create_context result is empty!");
                    throw new EverSdkException(new EverSdkException.ErrorResult(-502L, "FUNC:sdk.tc_create_context result is empty!"));
                }
                int ctxId = contextId.get();
                contexts.put(ctxId, new EverSdkContext(ctxId, mergedConfig));
                logger.log(System.Logger.Level.TRACE, () -> "FUNC:sdk.tc_create_context CTX:%d JSON:%s".formatted(ctxId, mergedJson));
                return ctxId;
            }
            catch (JsonProcessingException e) {
                String finalResultString = resultString;
                logger.log(System.Logger.Level.ERROR, () -> "FUNC:sdk.tc_create_context request deserialization failed! Exception: %s Result: %s".formatted((Object)e, finalResultString));
                throw new EverSdkException(new EverSdkException.ErrorResult(-501L, "FUNC:sdk.tc_create_context request deserialization failed!"), e.getCause());
            }
        }
        catch (JsonProcessingException e) {
            logger.log(System.Logger.Level.ERROR, () -> "EVER-SDK tc_create_context request serialization failed! Exception: %s Config: %s".formatted((Object)e, mergedConfig));
            throw new EverSdkException(new EverSdkException.ErrorResult(-502L, "EVER-SDK tc_create_context request serialization failed!"), e.getCause());
        }
    }

    public static int createWithJson(String configJson) throws EverSdkException {
        try {
            return EverSdk.createWithConfig((Client.ClientConfig)JsonContext.SDK_JSON_MAPPER().readValue(configJson, Client.ClientConfig.class));
        }
        catch (JsonProcessingException e) {
            logger.log(System.Logger.Level.ERROR, () -> "EVER-SDK tc_create_context request serialization failed! Exception: %s Config: %s".formatted((Object)e, configJson));
            throw new EverSdkException(new EverSdkException.ErrorResult(-502L, "EVER-SDK tc_create_context request serialization failed!"), e.getCause());
        }
    }

    public static Processing.ResultOfProcessMessage sendExternalMessage(int contextId, String dstAddress, Abi.ABI abi, String stateInit, String messageBody, String optionalSrcAddress) throws EverSdkException {
        String message = EverSdk.await(Boc.encodeExternalInMessage(contextId, optionalSrcAddress, dstAddress, stateInit, messageBody, null)).message();
        Processing.ResultOfSendMessage request = EverSdk.await(Processing.sendMessage(contextId, message, abi, false, null));
        return EverSdk.await(Processing.waitForTransaction(contextId, abi, message, request.shardBlockId(), false, request.sendingEndpoints(), null));
    }

    public static <T> T await(CompletableFuture<T> functionOutputs) throws EverSdkException {
        try {
            return functionOutputs.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex3) {
            logger.log(System.Logger.Level.ERROR, () -> "EVER-SDK Call interrupted! %s".formatted(ex3.toString()));
            throw new EverSdkException(new EverSdkException.ErrorResult(-400L, "EVER-SDK call interrupted!"), ex3.getCause());
        }
        catch (TimeoutException ex4) {
            logger.log(System.Logger.Level.ERROR, () -> "EVER-SDK Call expired on Timeout! %s".formatted(ex4.toString()));
            throw new EverSdkException(new EverSdkException.ErrorResult(-408L, "EVER-SDK call expired on Timeout!"), ex4.getCause());
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof EverSdkException) {
                EverSdkException everEx = (EverSdkException)throwable;
                throw everEx;
            }
            logger.log(System.Logger.Level.ERROR, () -> "EVER-SDK Call unknown execution exception! %s".formatted(e.toString()));
            throw new EverSdkException(new EverSdkException.ErrorResult(-500L, "EVER-SDK call expired on Timeout!"), e.getCause());
        }
    }

    public static class Builder {
        private Boolean cacheInLocalStorage = null;
        private String localStoragePath = null;
        private String[] endpoints = null;
        @Deprecated
        private String serverAddress;
        private Integer networkRetriesCount = null;
        private Integer messageRetriesCount = null;
        private Long messageProcessingTimeout = null;
        private Long waitForTimeout = null;
        private Long outOfSyncThreshold = null;
        private Long reconnectTimeout = null;
        private String accessKey = null;
        private Crypto.MnemonicDictionary mnemonicDictionary = null;
        private Integer mnemonicWordCount = null;
        private String hdkeyDerivationPath = null;
        private Long workchain = null;
        private Long messageExpirationTimeout = null;
        private Long messageExpirationTimeoutGrowFactor = null;
        private Long cacheMaxSize = null;
        private Long maxReconnectTimeout = null;
        private Integer sendingEndpointCount = null;
        private Long latencyDetectionInterval = null;
        private Long maxLatency = null;
        private Long queryTimeout = null;
        private Client.NetworkQueriesProtocol queriesProtocol = null;
        private Long firstRempStatusTimeout = null;
        private Long nextRempStatusTimeout = null;
        private Long signatureId = null;

        public Builder localStoragePath(String localStoragePath) {
            this.localStoragePath = localStoragePath;
            return this;
        }

        public Builder proofsCacheInLocalStorage(boolean cacheInLocalStorage) {
            this.cacheInLocalStorage = cacheInLocalStorage;
            return this;
        }

        public Builder networkMaxReconnectTimeout(Long maxReconnectTimeout) {
            this.maxReconnectTimeout = maxReconnectTimeout;
            return this;
        }

        public Builder networkSendingEndpointCount(Integer sendingEndpointCount) {
            this.sendingEndpointCount = sendingEndpointCount;
            return this;
        }

        public Builder networkLatencyDetectionInterval(Long latencyDetectionInterval) {
            this.latencyDetectionInterval = latencyDetectionInterval;
            return this;
        }

        public Builder networkMaxLatency(Long maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public Builder networkQueryTimeout(Long queryTimeout) {
            this.queryTimeout = queryTimeout;
            return this;
        }

        public Builder networkQueriesProtocol(Client.NetworkQueriesProtocol queriesProtocol) {
            this.queriesProtocol = queriesProtocol;
            return this;
        }

        public Builder networkFirstRempStatusTimeout(Long firstRempStatusTimeout) {
            this.firstRempStatusTimeout = firstRempStatusTimeout;
            return this;
        }

        public Builder networkNextRempStatusTimeout(Long nextRempStatusTimeout) {
            this.nextRempStatusTimeout = nextRempStatusTimeout;
            return this;
        }

        public Builder networkEndpoints(String ... endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        public Builder networkServerAddress(String server_address) {
            this.serverAddress = server_address;
            return this;
        }

        public Builder networkRetriesCount(Integer network_retries_count) {
            this.networkRetriesCount = network_retries_count;
            return this;
        }

        public Builder networkMessageRetriesCount(Integer message_retries_count) {
            this.messageRetriesCount = message_retries_count;
            return this;
        }

        public Builder networkMessageProcessingTimeout(Long message_processing_timeout) {
            this.messageProcessingTimeout = message_processing_timeout;
            return this;
        }

        public Builder networkWaitForTimeout(Long wait_for_timeout) {
            this.waitForTimeout = wait_for_timeout;
            return this;
        }

        public Builder networkOutOfSyncThreshold(Long out_of_sync_threshold) {
            this.outOfSyncThreshold = out_of_sync_threshold;
            return this;
        }

        public Builder networkReconnectTimeout(Long reconnect_timeout) {
            this.reconnectTimeout = reconnect_timeout;
            return this;
        }

        public Builder networkSignatureId(Long signatureId) {
            this.signatureId = signatureId;
            return this;
        }

        public Builder networkAccessKey(String access_key) {
            this.accessKey = access_key;
            return this;
        }

        public Builder cryptoMnemonicDictionary(Crypto.MnemonicDictionary mnemonic_dictionary) {
            this.mnemonicDictionary = mnemonic_dictionary;
            return this;
        }

        public Builder cryptoMnemonicWordCount(Integer mnemonic_word_count) {
            this.mnemonicWordCount = mnemonic_word_count;
            return this;
        }

        public Builder cryptoHdkeyDerivationPath(String hdkey_derivation_path) {
            this.hdkeyDerivationPath = hdkey_derivation_path;
            return this;
        }

        public Builder abiWorkchain(Long workchain) {
            this.workchain = workchain;
            return this;
        }

        public Builder abiMessageExpirationTimeout(Long message_expiration_timeout) {
            this.messageExpirationTimeout = message_expiration_timeout;
            return this;
        }

        public Builder abiMessageExpirationTimeoutGrowFactor(Long message_expiration_timeout_grow_factor) {
            this.messageExpirationTimeoutGrowFactor = message_expiration_timeout_grow_factor;
            return this;
        }

        public Builder bocCacheMaxSize(Long cacheMaxSize) {
            this.cacheMaxSize = cacheMaxSize;
            return this;
        }

        private Client.NetworkConfig buildNetworkConfig() {
            if (this.serverAddress == null && this.endpoints == null && this.networkRetriesCount == null && this.maxReconnectTimeout == null && this.reconnectTimeout == null && this.messageRetriesCount == null && this.messageProcessingTimeout == null && this.waitForTimeout == null && this.outOfSyncThreshold == null && this.sendingEndpointCount == null && this.latencyDetectionInterval == null && this.maxLatency == null && this.queryTimeout == null && this.queriesProtocol == null && this.firstRempStatusTimeout == null && this.nextRempStatusTimeout == null && this.signatureId == null && this.accessKey == null) {
                return null;
            }
            return new Client.NetworkConfig(this.serverAddress, this.endpoints, this.networkRetriesCount, this.maxReconnectTimeout, this.reconnectTimeout, this.messageRetriesCount, this.messageProcessingTimeout, this.waitForTimeout, this.outOfSyncThreshold, this.sendingEndpointCount, this.latencyDetectionInterval, this.maxLatency, this.queryTimeout, this.queriesProtocol, this.firstRempStatusTimeout, this.nextRempStatusTimeout, this.signatureId, this.accessKey);
        }

        private Client.CryptoConfig buildCryptoConfig() {
            if (this.mnemonicDictionary == null && this.mnemonicWordCount == null && this.hdkeyDerivationPath == null) {
                return null;
            }
            return new Client.CryptoConfig(this.mnemonicDictionary, this.mnemonicWordCount, this.hdkeyDerivationPath);
        }

        private Client.AbiConfig buildAbiConfig() {
            if (this.workchain == null && this.messageExpirationTimeout == null && this.messageExpirationTimeoutGrowFactor == null) {
                return null;
            }
            return new Client.AbiConfig(this.workchain, this.messageExpirationTimeout, this.messageExpirationTimeoutGrowFactor);
        }

        private Client.BocConfig buildBocConfig() {
            if (this.cacheMaxSize == null) {
                return null;
            }
            return new Client.BocConfig(this.cacheMaxSize);
        }

        private Client.ProofsConfig buildProofsConfig() {
            if (this.cacheInLocalStorage == null) {
                return null;
            }
            return new Client.ProofsConfig(this.cacheInLocalStorage);
        }

        public int build() throws EverSdkException {
            Client.ClientConfig config = new Client.ClientConfig(new Client.BindingConfig("java4ever", "3.0.0"), this.buildNetworkConfig(), this.buildCryptoConfig(), this.buildAbiConfig(), this.buildBocConfig(), this.buildProofsConfig(), this.localStoragePath);
            return EverSdk.createWithConfig(config);
        }
    }

    public record ResultOfCreateContext(Integer result, String error) {
    }
}

