/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.ffi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentScope;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import tech.deplant.commons.Strings;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Net;
import tech.deplant.java4ever.binding.ffi.SdkBridge;
import tech.deplant.java4ever.binding.ffi.tc_response_handler_t;
import tech.deplant.java4ever.binding.ffi.ton_client;

public class SdkResponseHandler
implements tc_response_handler_t {
    private static final System.Logger logger = System.getLogger(SdkResponseHandler.class.getName());
    private final int requestId;
    private final EverSdkContext ctx;
    private final String functionName;
    private final String params;
    private final CompletableFuture<String> result = new CompletableFuture();
    private final List<String> eventList = new ArrayList<String>();
    private final Consumer<String> handlerConsumer;
    private final Predicate<String> eventFilter;
    private long handle = 0L;

    public SdkResponseHandler(EverSdkContext ctx, int requestId, String functionName, String params, Consumer<String> consumer, Predicate<String> filter) {
        this.ctx = ctx;
        this.requestId = requestId;
        this.functionName = Strings.notEmpty((String)functionName);
        this.params = params;
        this.handlerConsumer = consumer;
        this.eventFilter = filter;
    }

    public int requestId() {
        return this.requestId;
    }

    public void saveHandle(long handle) {
        this.handle = handle;
    }

    public void request(ExecutorService executor, SegmentScope scope) {
        logger.log(System.Logger.Level.TRACE, () -> "FUNC:" + this.functionName + " CTXID:" + this.ctx.id() + " REQID:" + this.requestId + " SEND:" + this.params);
        ton_client.tc_request(this.ctx.id(), SdkBridge.toRustString(this.functionName, scope), SdkBridge.toRustString(this.params, scope), this.requestId, tc_response_handler_t.allocate(this, SegmentScope.auto()));
    }

    @Override
    public void apply(int x0, MemorySegment x1, int x2, boolean x3) {
        String responseString = Strings.notEmptyElse((String)SdkBridge.toString(x1, SegmentScope.auto()), (String)"{}");
        if (x2 == ton_client.tc_response_success()) {
            this.result.complete(responseString);
            logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, RESULT".formatted(x0));
        } else if (x2 == ton_client.tc_response_error()) {
            this.result.completeExceptionally(new CompletionException(responseString, null));
            logger.log(System.Logger.Level.WARNING, () -> "REQID: %d, ERROR".formatted(x0));
        } else if (x2 == ton_client.tc_response_nop()) {
            logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, NOP".formatted(x0));
            if (x3) {
                this.result.complete(responseString);
            }
        } else if (x2 == ton_client.tc_response_app_request()) {
            logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, APP_REQUEST".formatted(x0));
        } else if (x2 == ton_client.tc_response_app_notify()) {
            logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, APP_NOTIFY".formatted(x0));
        } else if (x2 > ton_client.tc_response_app_notify() && x2 < ton_client.tc_response_custom()) {
            logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, RESERVED".formatted(x0));
            if (x3) {
                this.result.complete(responseString);
            }
        } else {
            logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, CUSTOM #%d, %s".formatted(x0, x2, responseString));
            if (this.handlerConsumer != null) {
                this.eventList.add(responseString);
                if (this.eventFilter == null || this.eventFilter.test(responseString)) {
                    Consumer<String> consumer = this.handlerConsumer;
                    if (this.handle > 0L) {
                        consumer = this.handlerConsumer.andThen(event -> {
                            try {
                                Net.unsubscribe(this.ctx, new Net.ResultOfSubscribeCollection(this.handle));
                            }
                            catch (EverSdkException e) {
                                logger.log(System.Logger.Level.ERROR, () -> "Unsubscribe failed! REQID: %s, Handle: %s".formatted(this.requestId, this.handle));
                            }
                        });
                        logger.log(System.Logger.Level.TRACE, () -> "Unsubscribing handle: " + this.handle);
                    }
                    this.ctx.responses().remove(this.requestId);
                    logger.log(System.Logger.Level.TRACE, () -> "Removing request by event acception: " + this.requestId);
                    consumer.accept(responseString);
                }
            }
        }
    }

    public String result(ObjectMapper mapper, long timeout, TimeUnit unit) throws EverSdkException {
        try {
            String result = this.result.get(timeout, unit);
            logger.log(System.Logger.Level.TRACE, () -> "FUNC: " + this.functionName + " CTXID:" + this.ctx.id() + " REQID:" + this.requestId + " RESP:" + result);
            return result;
        }
        catch (CompletionException | ExecutionException e) {
            EverSdkException.ErrorResult sdkResponse = null;
            try {
                EverSdkException.ErrorResult responseCopy = sdkResponse = (EverSdkException.ErrorResult)mapper.readValue(e.getCause().getMessage(), EverSdkException.ErrorResult.class);
                if (responseCopy.data().localError() != null && responseCopy.data().localError().data().exitCode() > 0) {
                    logger.log(System.Logger.Level.WARNING, () -> "Error from SDK. Code: " + responseCopy.data().localError().code() + ", Message: " + responseCopy.data().localError().message());
                    throw new EverSdkException(new EverSdkException.ErrorResult(responseCopy.data().localError().data().exitCode(), "Contract did not accept message. For more information about exit code check the contract source code or ask the contract developer", responseCopy.data().localError().data()), (Throwable)e);
                }
                logger.log(System.Logger.Level.WARNING, () -> "Error from SDK. Code: " + responseCopy.code() + ", Message: " + responseCopy.message());
                throw new EverSdkException(responseCopy, (Throwable)e);
            }
            catch (JsonProcessingException ex) {
                logger.log(System.Logger.Level.ERROR, () -> "SDK Error Response deserialization failed! Response: " + e.getCause().getMessage() + ex.getMessage());
                throw new EverSdkException(new EverSdkException.ErrorResult(-500L, "SDK Error Response deserialization failed! Check getCause() for actual response."), (Throwable)ex);
            }
        }
        catch (InterruptedException e) {
            logger.log(System.Logger.Level.ERROR, () -> "FUNC:" + this.functionName + " CTXID:" + this.ctx.id() + " REQID:" + this.requestId + " ERR: INTERRUPTED! " + this.params + String.valueOf(e.getCause()) + " " + e.getMessage() + " " + String.valueOf(e));
            throw new EverSdkException(new EverSdkException.ErrorResult(-400L, "EVER-SDK call interrupted!"), (Throwable)e);
        }
        catch (TimeoutException e) {
            logger.log(System.Logger.Level.ERROR, () -> "FUNC:" + this.functionName + " CTXID:" + this.ctx.id() + " REQID:" + this.requestId + " ERR: TIMEOUT! LIMIT: " + timeout + " Message: " + e.getMessage());
            throw new EverSdkException(new EverSdkException.ErrorResult(-402L, "EVER-SDK Execution expired on Timeout! Current timeout: " + timeout), (Throwable)e);
        }
    }
}

