/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Consumer;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;

public final class Net {
    public static ResultOfQuery query(EverSdkContext ctx, String query, JsonNode variables) throws EverSdkException {
        return ctx.call("net.query", new ParamsOfQuery(query, variables), ResultOfQuery.class);
    }

    public static ResultOfBatchQuery batchQuery(EverSdkContext ctx, ParamsOfQueryOperation[] operations) throws EverSdkException {
        return ctx.call("net.batch_query", new ParamsOfBatchQuery(operations), ResultOfBatchQuery.class);
    }

    public static ResultOfQueryCollection queryCollection(EverSdkContext ctx, String collection, JsonNode filter, String result, OrderBy[] order, Long limit) throws EverSdkException {
        return ctx.call("net.query_collection", new ParamsOfQueryCollection(collection, filter, result, order, limit), ResultOfQueryCollection.class);
    }

    public static ResultOfAggregateCollection aggregateCollection(EverSdkContext ctx, String collection, JsonNode filter, FieldAggregation[] fields) throws EverSdkException {
        return ctx.call("net.aggregate_collection", new ParamsOfAggregateCollection(collection, filter, fields), ResultOfAggregateCollection.class);
    }

    public static ResultOfWaitForCollection waitForCollection(EverSdkContext ctx, String collection, JsonNode filter, String result, Long timeout) throws EverSdkException {
        return ctx.call("net.wait_for_collection", new ParamsOfWaitForCollection(collection, filter, result, timeout), ResultOfWaitForCollection.class);
    }

    public static void unsubscribe(EverSdkContext ctx, ResultOfSubscribeCollection params) throws EverSdkException {
        ctx.callVoid("net.unsubscribe", params);
    }

    public static ResultOfSubscribeCollection subscribeCollection(EverSdkContext ctx, String collection, JsonNode filter, String result, Consumer<String> eventHandler) throws EverSdkException {
        return ctx.callEvent("net.subscribe_collection", new ParamsOfSubscribeCollection(collection, filter, result), eventHandler, ResultOfSubscribeCollection.class);
    }

    public static ResultOfSubscribeCollection subscribe(EverSdkContext ctx, String subscription, JsonNode variables, Consumer<String> eventHandler) throws EverSdkException {
        return ctx.callEvent("net.subscribe", new ParamsOfSubscribe(subscription, variables), eventHandler, ResultOfSubscribeCollection.class);
    }

    public static void suspend(EverSdkContext ctx) throws EverSdkException {
        ctx.callVoid("net.suspend", null);
    }

    public static void resume(EverSdkContext ctx) throws EverSdkException {
        ctx.callVoid("net.resume", null);
    }

    public static ResultOfFindLastShardBlock findLastShardBlock(EverSdkContext ctx, String address) throws EverSdkException {
        return ctx.call("net.find_last_shard_block", new ParamsOfFindLastShardBlock(address), ResultOfFindLastShardBlock.class);
    }

    public static EndpointsSet fetchEndpoints(EverSdkContext ctx) throws EverSdkException {
        return ctx.call("net.fetch_endpoints", null, EndpointsSet.class);
    }

    public static void setEndpoints(EverSdkContext ctx, EndpointsSet params) throws EverSdkException {
        ctx.callVoid("net.set_endpoints", params);
    }

    public static ResultOfGetEndpoints getEndpoints(EverSdkContext ctx) throws EverSdkException {
        return ctx.call("net.get_endpoints", null, ResultOfGetEndpoints.class);
    }

    public static ResultOfQueryCollection queryCounterparties(EverSdkContext ctx, String account, String result, Long first, String after) throws EverSdkException {
        return ctx.call("net.query_counterparties", new ParamsOfQueryCounterparties(account, result, first, after), ResultOfQueryCollection.class);
    }

    public static ResultOfQueryTransactionTree queryTransactionTree(EverSdkContext ctx, String inMsg, Abi.ABI[] abiRegistry, Long timeout, Long transactionMaxCount) throws EverSdkException {
        return ctx.call("net.query_transaction_tree", new ParamsOfQueryTransactionTree(inMsg, abiRegistry, timeout, transactionMaxCount), ResultOfQueryTransactionTree.class);
    }

    public static RegisteredIterator createBlockIterator(EverSdkContext ctx, Long startTime, Long endTime, String[] shardFilter, String result) throws EverSdkException {
        return ctx.call("net.create_block_iterator", new ParamsOfCreateBlockIterator(startTime, endTime, shardFilter, result), RegisteredIterator.class);
    }

    public static RegisteredIterator resumeBlockIterator(EverSdkContext ctx, JsonNode resumeState) throws EverSdkException {
        return ctx.call("net.resume_block_iterator", new ParamsOfResumeBlockIterator(resumeState), RegisteredIterator.class);
    }

    public static RegisteredIterator createTransactionIterator(EverSdkContext ctx, Long startTime, Long endTime, String[] shardFilter, String[] accountsFilter, String result, Boolean includeTransfers) throws EverSdkException {
        return ctx.call("net.create_transaction_iterator", new ParamsOfCreateTransactionIterator(startTime, endTime, shardFilter, accountsFilter, result, includeTransfers), RegisteredIterator.class);
    }

    public static RegisteredIterator resumeTransactionIterator(EverSdkContext ctx, JsonNode resumeState, String[] accountsFilter) throws EverSdkException {
        return ctx.call("net.resume_transaction_iterator", new ParamsOfResumeTransactionIterator(resumeState, accountsFilter), RegisteredIterator.class);
    }

    public static ResultOfIteratorNext iteratorNext(EverSdkContext ctx, Long iterator, Long limit, Boolean returnResumeState) throws EverSdkException {
        return ctx.call("net.iterator_next", new ParamsOfIteratorNext(iterator, limit, returnResumeState), ResultOfIteratorNext.class);
    }

    public static void removeIterator(EverSdkContext ctx, RegisteredIterator params) throws EverSdkException {
        ctx.callVoid("net.remove_iterator", params);
    }

    public static ResultOfGetSignatureId getSignatureId(EverSdkContext ctx) throws EverSdkException {
        return ctx.call("net.get_signature_id", null, ResultOfGetSignatureId.class);
    }

    public record ParamsOfQuery(String query, JsonNode variables) {
    }

    public record ResultOfQuery(JsonNode result) {
    }

    public record ParamsOfBatchQuery(ParamsOfQueryOperation[] operations) {
    }

    public static sealed interface ParamsOfQueryOperation
    permits ParamsOfQueryCollection, ParamsOfWaitForCollection, ParamsOfQueryCounterparties, ParamsOfAggregateCollection {
    }

    public record ResultOfBatchQuery(JsonNode[] results) {
    }

    public record ParamsOfQueryCollection(String collection, JsonNode filter, String result, OrderBy[] order, Long limit) implements ParamsOfQueryOperation
    {
        @JsonProperty(value="type")
        public String type() {
            return "QueryCollection";
        }
    }

    public record OrderBy(String path, SortDirection direction) {
    }

    public record ResultOfQueryCollection(JsonNode[] result) {
    }

    public record ParamsOfAggregateCollection(String collection, JsonNode filter, FieldAggregation[] fields) implements ParamsOfQueryOperation
    {
        @JsonProperty(value="type")
        public String type() {
            return "AggregateCollection";
        }
    }

    public record FieldAggregation(String field, AggregationFn fn) {
    }

    public record ResultOfAggregateCollection(JsonNode values) {
    }

    public record ParamsOfWaitForCollection(String collection, JsonNode filter, String result, Long timeout) implements ParamsOfQueryOperation
    {
        @JsonProperty(value="type")
        public String type() {
            return "WaitForCollection";
        }
    }

    public record ResultOfWaitForCollection(JsonNode result) {
    }

    public record ParamsOfSubscribeCollection(String collection, JsonNode filter, String result) {
    }

    public record ResultOfSubscribeCollection(Long handle) {
    }

    public record ParamsOfSubscribe(String subscription, JsonNode variables) {
    }

    public record ParamsOfFindLastShardBlock(String address) {
    }

    public record ResultOfFindLastShardBlock(String blockId) {
    }

    public record EndpointsSet(String[] endpoints) {
    }

    public record ResultOfGetEndpoints(String query, String[] endpoints) {
    }

    public record ParamsOfQueryCounterparties(String account, String result, Long first, String after) implements ParamsOfQueryOperation
    {
        @JsonProperty(value="type")
        public String type() {
            return "QueryCounterparties";
        }
    }

    public record ParamsOfQueryTransactionTree(String inMsg, Abi.ABI[] abiRegistry, Long timeout, Long transactionMaxCount) {
    }

    public record ResultOfQueryTransactionTree(MessageNode[] messages, TransactionNode[] transactions) {
    }

    public record ParamsOfCreateBlockIterator(Long startTime, Long endTime, String[] shardFilter, String result) {
    }

    public record RegisteredIterator(Long handle) {
    }

    public record ParamsOfResumeBlockIterator(JsonNode resumeState) {
    }

    public record ParamsOfCreateTransactionIterator(Long startTime, Long endTime, String[] shardFilter, String[] accountsFilter, String result, Boolean includeTransfers) {
    }

    public record ParamsOfResumeTransactionIterator(JsonNode resumeState, String[] accountsFilter) {
    }

    public record ParamsOfIteratorNext(Long iterator, Long limit, Boolean returnResumeState) {
    }

    public record ResultOfIteratorNext(JsonNode[] items, Boolean hasMore, JsonNode resumeState) {
    }

    public record ResultOfGetSignatureId(Long signatureId) {
    }

    public record TransactionNode(String id, String inMsg, String[] outMsgs, String accountAddr, String totalFees, Boolean aborted, Long exitCode) {
    }

    public static enum NetErrorCode {
        QueryFailed(601),
        SubscribeFailed(602),
        WaitForFailed(603),
        GetSubscriptionResultFailed(604),
        InvalidServerResponse(605),
        ClockOutOfSync(606),
        WaitForTimeout(607),
        GraphqlError(608),
        NetworkModuleSuspended(609),
        WebsocketDisconnected(610),
        NotSupported(611),
        NoEndpointsProvided(612),
        GraphqlWebsocketInitError(613),
        NetworkModuleResumed(614),
        Unauthorized(615),
        QueryTransactionTreeTimeout(616),
        GraphqlConnectionError(617),
        WrongWebscoketProtocolSequence(618);

        private final Integer value;

        private NetErrorCode(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer value() {
            return this.value;
        }
    }

    public record MessageNode(String id, String srcTransactionId, String dstTransactionId, String src, String dst, String value, Boolean bounce, Abi.DecodedMessageBody decodedBody) {
    }

    public static enum AggregationFn {
        COUNT,
        MIN,
        MAX,
        SUM,
        AVERAGE;

    }

    public static enum SortDirection {
        ASC,
        DESC;

    }
}

