/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import tech.deplant.java4ever.binding.CallbackHandler;
import tech.deplant.java4ever.binding.Client;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.binding.ffi.SdkBridge;
import tech.deplant.java4ever.binding.loader.DefaultLoaderContext;
import tech.deplant.java4ever.binding.loader.LibraryLoader;

public record EverSdkContext(int id, @JsonIgnore ObjectMapper mapper, long timeout, AtomicInteger requestCount) {
    private static final System.Logger logger = System.getLogger(EverSdkContext.class.getName());

    public EverSdkContext(int id, int requestCount, long timeout, ObjectMapper mapper) {
        this(id, mapper, timeout, new AtomicInteger(requestCount));
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T, P, A> T callAppObject(String functionName, P params, A appObject, Class<T> clazz) throws EverSdkException {
        return this.call(functionName, params, clazz);
    }

    public <T, P> T callEvent(String functionName, P params, Consumer<CallbackHandler> consumer, Class<T> clazz) throws EverSdkException {
        try {
            return (T)this.mapper.readValue(this.processRequest(functionName, this.processParams(params), consumer), clazz);
        }
        catch (JsonProcessingException e) {
            logger.log(System.Logger.Level.ERROR, () -> "Successful response deserialization failed!" + e.getMessage() + String.valueOf(e.getCause()));
            throw new EverSdkException(new EverSdkException.ErrorResult(-500L, "Successful response deserialization failed! Check getCause() for actual response."), (Throwable)e);
        }
    }

    public <T, P> T call(String functionName, P params, Class<T> clazz) throws EverSdkException {
        try {
            return (T)this.mapper.readValue(this.processRequest(functionName, this.processParams(params), null), clazz);
        }
        catch (JsonProcessingException e) {
            logger.log(System.Logger.Level.ERROR, () -> "Successful response deserialization failed!" + e.getMessage() + String.valueOf(e.getCause()));
            throw new EverSdkException(new EverSdkException.ErrorResult(-500L, "Successful response deserialization failed! Check getCause() for actual response."), (Throwable)e);
        }
    }

    public <P> void callVoid(String functionName, P params) throws EverSdkException {
        this.processRequest(functionName, this.processParams(params), null);
    }

    private <P> String processParams(P params) throws EverSdkException {
        try {
            return null == params ? "" : this.mapper.writeValueAsString(params);
        }
        catch (JsonProcessingException e) {
            logger.log(System.Logger.Level.ERROR, () -> "Parameters serialization failed!" + e.getMessage() + String.valueOf(e.getCause()));
            throw new EverSdkException(new EverSdkException.ErrorResult(-501L, "Parameters serialization failed!"), (Throwable)e);
        }
    }

    private String processRequest(String functionName, String params, Consumer<CallbackHandler> consumer) throws EverSdkException {
        int requestId = this.requestCount().incrementAndGet();
        try {
            logger.log(System.Logger.Level.TRACE, () -> "FUNC:" + functionName + " CTXID:" + this.id() + " REQID:" + requestId + " SEND:" + params);
            String result = SdkBridge.tcRequest(this.id(), requestId, functionName, params, consumer).result().get(this.timeout(), TimeUnit.MILLISECONDS);
            logger.log(System.Logger.Level.TRACE, () -> "FUNC: " + functionName + " CTXID:" + this.id() + " REQID:" + requestId + " RESP:" + result);
            return result;
        }
        catch (CompletionException | ExecutionException e) {
            EverSdkException.ErrorResult sdkResponse = null;
            try {
                EverSdkException.ErrorResult responseCopy = sdkResponse = (EverSdkException.ErrorResult)this.mapper().readValue(e.getCause().getMessage(), EverSdkException.ErrorResult.class);
                if (responseCopy.data().localError() != null && responseCopy.data().localError().data().exitCode() > 0) {
                    logger.log(System.Logger.Level.WARNING, () -> "Error from SDK. Code: " + responseCopy.data().localError().code() + ", Message: " + responseCopy.data().localError().message());
                    throw new EverSdkException(new EverSdkException.ErrorResult(responseCopy.data().localError().data().exitCode(), "Contract did not accept message. For more information about exit code check the contract source code or ask the contract developer", responseCopy.data().localError().data()), (Throwable)e);
                }
                logger.log(System.Logger.Level.WARNING, () -> "Error from SDK. Code: " + responseCopy.code() + ", Message: " + responseCopy.message());
                throw new EverSdkException(responseCopy, (Throwable)e);
            }
            catch (JsonProcessingException ex) {
                logger.log(System.Logger.Level.ERROR, () -> "SDK Error Response deserialization failed! Response: " + e.getCause().getMessage() + ex.getMessage());
                throw new EverSdkException(new EverSdkException.ErrorResult(-500L, "SDK Error Response deserialization failed! Check getCause() for actual response."), (Throwable)ex);
            }
        }
        catch (InterruptedException e) {
            logger.log(System.Logger.Level.ERROR, () -> "FUNC:" + functionName + " CTXID:" + this.id() + " REQID:" + requestId + " ERR: INTERRUPTED! " + params + String.valueOf(e.getCause()) + " " + e.getMessage() + " " + String.valueOf(e));
            throw new EverSdkException(new EverSdkException.ErrorResult(-400L, "EVER-SDK call interrupted!"), (Throwable)e);
        }
        catch (TimeoutException e) {
            logger.log(System.Logger.Level.ERROR, () -> "FUNC:" + functionName + " CTXID:" + this.id() + " REQID:" + requestId + " ERR: TIMEOUT! LIMIT: " + this.timeout() + " Message: " + e.getMessage());
            throw new EverSdkException(new EverSdkException.ErrorResult(-402L, "EVER-SDK Execution expired on Timeout! Current timeout: " + this.timeout()), (Throwable)e);
        }
    }

    public static class Builder {
        private long timeout = 60000L;
        private String configJson = "{}";
        private ObjectMapper jsonMapper;

        public Builder setConfigJson(String configJson) {
            this.configJson = configJson;
            return this;
        }

        public Builder setTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setMapper(ObjectMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
            return this;
        }

        public EverSdkContext buildFromExisting(int existingContextId, int existingContextRequestCount) {
            return new EverSdkContext(existingContextId, existingContextRequestCount, this.timeout, this.jsonMapper);
        }

        public EverSdkContext buildNew(LibraryLoader loader) throws JsonProcessingException {
            Client.ClientConfig defaults;
            Client.ClientConfig mergedConfig;
            String mergedJson;
            ResultOfCreateContext createContextResponse;
            if (this.jsonMapper == null) {
                this.jsonMapper = JsonContext.SDK_JSON_MAPPER();
            }
            if ((createContextResponse = (ResultOfCreateContext)this.jsonMapper.readValue(SdkBridge.tcCreateContext(loader, mergedJson = this.jsonMapper.writeValueAsString((Object)(mergedConfig = new Client.ClientConfig(new Client.BindingConfig("java4ever", "2.4.0"), (defaults = (Client.ClientConfig)this.jsonMapper.readValue(this.configJson, Client.ClientConfig.class)).network(), defaults.crypto(), defaults.abi(), defaults.boc(), defaults.proofs(), defaults.localStoragePath())))), ResultOfCreateContext.class)).result() == null || createContextResponse.result() < 1) {
                throw new RuntimeException("sdk.create_context failed!");
            }
            return new EverSdkContext((int)createContextResponse.result(), 0, this.timeout, this.jsonMapper);
        }

        public EverSdkContext buildNew() throws JsonProcessingException {
            return this.buildNew(DefaultLoaderContext.SINGLETON(this.getClass().getClassLoader()));
        }

        public record ResultOfCreateContext(Integer result, String error) {
        }
    }
}

