/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.ffi;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import tech.deplant.java4ever.binding.ffi.SdkBridge;
import tech.deplant.java4ever.binding.ffi.tc_response_handler_t;

public class SdkResponseHandler
implements tc_response_handler_t {
    private static final System.Logger logger = System.getLogger(SdkResponseHandler.class.getName());
    private final CompletableFuture<String> result = new CompletableFuture();

    @Override
    public void apply(int x0, MemorySegment x1, int x2, boolean x3) {
        try (Arena arenaScope = Arena.openShared();){
            if (x2 == 0) {
                this.result.complete(SdkBridge.toString(x1));
                logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, RESULT".formatted(x0));
            } else if (x2 == 1) {
                this.result.completeExceptionally(new CompletionException(SdkBridge.toString(x1), null));
                logger.log(System.Logger.Level.WARNING, () -> "REQID: %d, ERROR".formatted(x0));
            } else if (x2 == 2) {
                logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, NOP".formatted(x0));
                if (x3) {
                    this.result.complete(SdkBridge.toString(x1));
                }
            } else if (x2 == 3) {
                logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, APP_REQUEST".formatted(x0));
            } else if (x2 == 4) {
                logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, APP_NOTIFY".formatted(x0));
            } else if (x2 >= 5 && x2 <= 99) {
                logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, RESERVED".formatted(x0));
                if (x3) {
                    this.result.complete(SdkBridge.toString(x1));
                }
            } else {
                logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, CUSTOM".formatted(x0));
            }
        }
    }

    public CompletableFuture<String> result() {
        return this.result;
    }
}

