/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import tech.deplant.java4ever.binding.Boc;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.Crypto;
import tech.deplant.java4ever.binding.EverSdkException;

public final class Abi {
    public static ResultOfEncodeMessageBody encodeMessageBody(Context ctx, ABI abi, CallSet callSet, Boolean isInternal, Signer signer, Integer processingTryIndex, String address) throws EverSdkException {
        return ctx.call("abi.encode_message_body", new ParamsOfEncodeMessageBody(abi, callSet, isInternal, signer, processingTryIndex, address), ResultOfEncodeMessageBody.class);
    }

    public static ResultOfAttachSignatureToMessageBody attachSignatureToMessageBody(Context ctx, ABI abi, String publicKey, String message, String signature) throws EverSdkException {
        return ctx.call("abi.attach_signature_to_message_body", new ParamsOfAttachSignatureToMessageBody(abi, publicKey, message, signature), ResultOfAttachSignatureToMessageBody.class);
    }

    public static ResultOfEncodeMessage encodeMessage(Context ctx, ABI abi, String address, DeploySet deploySet, CallSet callSet, Signer signer, Integer processingTryIndex) throws EverSdkException {
        return ctx.call("abi.encode_message", new ParamsOfEncodeMessage(abi, address, deploySet, callSet, signer, processingTryIndex), ResultOfEncodeMessage.class);
    }

    public static ResultOfEncodeInternalMessage encodeInternalMessage(Context ctx, ABI abi, String address, String srcAddress, DeploySet deploySet, CallSet callSet, String value, Boolean bounce, Boolean enableIhr) throws EverSdkException {
        return ctx.call("abi.encode_internal_message", new ParamsOfEncodeInternalMessage(abi, address, srcAddress, deploySet, callSet, value, bounce, enableIhr), ResultOfEncodeInternalMessage.class);
    }

    public static ResultOfAttachSignature attachSignature(Context ctx, ABI abi, String publicKey, String message, String signature) throws EverSdkException {
        return ctx.call("abi.attach_signature", new ParamsOfAttachSignature(abi, publicKey, message, signature), ResultOfAttachSignature.class);
    }

    public static DecodedMessageBody decodeMessage(Context ctx, ABI abi, String message, Boolean allowPartial, String functionName, DataLayout dataLayout) throws EverSdkException {
        return ctx.call("abi.decode_message", new ParamsOfDecodeMessage(abi, message, allowPartial, functionName, dataLayout), DecodedMessageBody.class);
    }

    public static DecodedMessageBody decodeMessageBody(Context ctx, ABI abi, String body, Boolean isInternal, Boolean allowPartial, String functionName, DataLayout dataLayout) throws EverSdkException {
        return ctx.call("abi.decode_message_body", new ParamsOfDecodeMessageBody(abi, body, isInternal, allowPartial, functionName, dataLayout), DecodedMessageBody.class);
    }

    public static ResultOfEncodeAccount encodeAccount(Context ctx, StateInitSource stateInit, Long balance, Long lastTransLt, Integer lastPaid, Boc.BocCacheType bocCache) throws EverSdkException {
        return ctx.call("abi.encode_account", new ParamsOfEncodeAccount(stateInit, balance, lastTransLt, lastPaid, bocCache), ResultOfEncodeAccount.class);
    }

    public static ResultOfDecodeAccountData decodeAccountData(Context ctx, ABI abi, String data, Boolean allowPartial) throws EverSdkException {
        return ctx.call("abi.decode_account_data", new ParamsOfDecodeAccountData(abi, data, allowPartial), ResultOfDecodeAccountData.class);
    }

    public static ResultOfUpdateInitialData updateInitialData(Context ctx, ABI abi, String data, Map<String, Object> initialData, String initialPubkey, Boc.BocCacheType bocCache) throws EverSdkException {
        return ctx.call("abi.update_initial_data", new ParamsOfUpdateInitialData(abi, data, initialData, initialPubkey, bocCache), ResultOfUpdateInitialData.class);
    }

    public static ResultOfEncodeInitialData encodeInitialData(Context ctx, ABI abi, Map<String, Object> initialData, String initialPubkey, Boc.BocCacheType bocCache) throws EverSdkException {
        return ctx.call("abi.encode_initial_data", new ParamsOfEncodeInitialData(abi, initialData, initialPubkey, bocCache), ResultOfEncodeInitialData.class);
    }

    public static ResultOfDecodeInitialData decodeInitialData(Context ctx, ABI abi, String data, Boolean allowPartial) throws EverSdkException {
        return ctx.call("abi.decode_initial_data", new ParamsOfDecodeInitialData(abi, data, allowPartial), ResultOfDecodeInitialData.class);
    }

    public static ResultOfDecodeBoc decodeBoc(Context ctx, AbiParam[] params, String boc, Boolean allowPartial) throws EverSdkException {
        return ctx.call("abi.decode_boc", new ParamsOfDecodeBoc(params, boc, allowPartial), ResultOfDecodeBoc.class);
    }

    public static ResultOfAbiEncodeBoc encodeBoc(Context ctx, AbiParam[] params, Map<String, Object> data, Boc.BocCacheType bocCache) throws EverSdkException {
        return ctx.call("abi.encode_boc", new ParamsOfAbiEncodeBoc(params, data, bocCache), ResultOfAbiEncodeBoc.class);
    }

    public static ResultOfCalcFunctionId calcFunctionId(Context ctx, ABI abi, String functionName, Boolean output) throws EverSdkException {
        return ctx.call("abi.calc_function_id", new ParamsOfCalcFunctionId(abi, functionName, output), ResultOfCalcFunctionId.class);
    }

    public static ResultOfGetSignatureData getSignatureData(Context ctx, ABI abi, String message) throws EverSdkException {
        return ctx.call("abi.get_signature_data", new ParamsOfGetSignatureData(abi, message), ResultOfGetSignatureData.class);
    }

    public record ParamsOfEncodeMessageBody(ABI abi, CallSet callSet, Boolean isInternal, Signer signer, Integer processingTryIndex, String address) {
    }

    public static sealed interface ABI {

        public record Serialized(AbiContract value) implements ABI
        {
            @JsonProperty(value="type")
            public String type() {
                return "Serialized";
            }
        }

        public record Handle(Integer value) implements ABI
        {
            @JsonProperty(value="type")
            public String type() {
                return "Handle";
            }
        }

        public record Json(String value) implements ABI
        {
            @JsonProperty(value="type")
            public String type() {
                return "Json";
            }
        }

        public record Contract(AbiContract value) implements ABI
        {
            @JsonProperty(value="type")
            public String type() {
                return "Contract";
            }
        }
    }

    public record CallSet(String functionName, FunctionHeader header, Map<String, Object> input) {
    }

    public static sealed interface Signer {

        public record SigningBox(Integer handle) implements Signer
        {
            @JsonProperty(value="type")
            public String type() {
                return "SigningBox";
            }
        }

        public record Keys(Crypto.KeyPair keys) implements Signer
        {
            @JsonProperty(value="type")
            public String type() {
                return "Keys";
            }
        }

        public record External(String publicKey) implements Signer
        {
            @JsonProperty(value="type")
            public String type() {
                return "External";
            }
        }

        public record None() implements Signer
        {
            @JsonProperty(value="type")
            public String type() {
                return "None";
            }
        }
    }

    public record ResultOfEncodeMessageBody(String body, String dataToSign) {
    }

    public record ParamsOfAttachSignatureToMessageBody(ABI abi, String publicKey, String message, String signature) {
    }

    public record ResultOfAttachSignatureToMessageBody(String body) {
    }

    public record ParamsOfEncodeMessage(ABI abi, String address, DeploySet deploySet, CallSet callSet, Signer signer, Integer processingTryIndex) implements MessageSource
    {
        @JsonProperty(value="type")
        public String type() {
            return "EncodingParams";
        }
    }

    public record DeploySet(String tvc, Integer workchainId, Map<String, Object> initialData, String initialPubkey) {
    }

    public record ResultOfEncodeMessage(String message, String dataToSign, String address, String messageId) {
    }

    public record ParamsOfEncodeInternalMessage(ABI abi, String address, String srcAddress, DeploySet deploySet, CallSet callSet, String value, Boolean bounce, Boolean enableIhr) {
    }

    public record ResultOfEncodeInternalMessage(String message, String address, String messageId) {
    }

    public record ParamsOfAttachSignature(ABI abi, String publicKey, String message, String signature) {
    }

    public record ResultOfAttachSignature(String message, String messageId) {
    }

    public record ParamsOfDecodeMessage(ABI abi, String message, Boolean allowPartial, String functionName, DataLayout dataLayout) {
    }

    public static enum DataLayout {
        Input,
        Output;

    }

    public record DecodedMessageBody(MessageBodyType bodyType, String name, Map<String, Object> value, FunctionHeader header) {
    }

    public record ParamsOfDecodeMessageBody(ABI abi, String body, Boolean isInternal, Boolean allowPartial, String functionName, DataLayout dataLayout) {
    }

    public record ParamsOfEncodeAccount(StateInitSource stateInit, Long balance, Long lastTransLt, Integer lastPaid, Boc.BocCacheType bocCache) {
    }

    public static sealed interface StateInitSource {

        public record Tvc(String tvc, String publicKey, StateInitParams initParams) implements StateInitSource
        {
            @JsonProperty(value="type")
            public String type() {
                return "Tvc";
            }
        }

        public record StateInit(String code, String data, String library) implements StateInitSource
        {
            @JsonProperty(value="type")
            public String type() {
                return "StateInit";
            }
        }

        public record Message(MessageSource source) implements StateInitSource
        {
            @JsonProperty(value="type")
            public String type() {
                return "Message";
            }
        }
    }

    public record ResultOfEncodeAccount(String account, String id) {
    }

    public record ParamsOfDecodeAccountData(ABI abi, String data, Boolean allowPartial) {
    }

    public record ResultOfDecodeAccountData(Map<String, Object> data) {
    }

    public record ParamsOfUpdateInitialData(ABI abi, String data, Map<String, Object> initialData, String initialPubkey, Boc.BocCacheType bocCache) {
    }

    public record ResultOfUpdateInitialData(String data) {
    }

    public record ParamsOfEncodeInitialData(ABI abi, Map<String, Object> initialData, String initialPubkey, Boc.BocCacheType bocCache) {
    }

    public record ResultOfEncodeInitialData(String data) {
    }

    public record ParamsOfDecodeInitialData(ABI abi, String data, Boolean allowPartial) {
    }

    public record ResultOfDecodeInitialData(Map<String, Object> initialData, String initialPubkey) {
    }

    public record ParamsOfDecodeBoc(AbiParam[] params, String boc, Boolean allowPartial) {
    }

    public record AbiParam(String name, String type, AbiParam[] components) {
    }

    public record ResultOfDecodeBoc(Map<String, Object> data) {
    }

    public record ParamsOfAbiEncodeBoc(AbiParam[] params, Map<String, Object> data, Boc.BocCacheType bocCache) {
    }

    public record ResultOfAbiEncodeBoc(String boc) {
    }

    public record ParamsOfCalcFunctionId(ABI abi, String functionName, Boolean output) {
    }

    public record ResultOfCalcFunctionId(Integer functionId) {
    }

    public record ParamsOfGetSignatureData(ABI abi, String message) {
    }

    public record ResultOfGetSignatureData(String signature, String hash) {
    }

    public record FunctionHeader(Integer expire, Long time, String pubkey) {
    }

    public static enum AbiErrorCode {
        RequiredAddressMissingForEncodeMessage(301),
        RequiredCallSetMissingForEncodeMessage(302),
        InvalidJson(303),
        InvalidMessage(304),
        EncodeDeployMessageFailed(305),
        EncodeRunMessageFailed(306),
        AttachSignatureFailed(307),
        InvalidTvcImage(308),
        RequiredPublicKeyMissingForFunctionHeader(309),
        InvalidSigner(310),
        InvalidAbi(311),
        InvalidFunctionId(312),
        InvalidData(313),
        EncodeInitialDataFailed(314),
        InvalidFunctionName(315);

        private final Integer value;

        private AbiErrorCode(Integer value) {
            this.value = value;
        }

        public Integer value() {
            return this.value;
        }
    }

    public record StateInitParams(ABI abi, Map<String, Object> value) {
    }

    public record AbiData(Integer key, String name, String type, AbiParam[] components) {
    }

    public static sealed interface MessageSource
    permits Encoded, ParamsOfEncodeMessage {

        public record Encoded(String message, ABI abi) implements MessageSource
        {
            @JsonProperty(value="type")
            public String type() {
                return "Encoded";
            }
        }
    }

    @JsonIgnoreProperties(value={"outputs"})
    public record AbiEvent(String name, AbiParam[] inputs, String id) {
    }

    public record AbiFunction(String name, AbiParam[] inputs, AbiParam[] outputs, String id) {
    }

    public static enum MessageBodyType {
        Input,
        Output,
        InternalOutput,
        Event;

    }

    public record AbiContract(@JsonProperty(value="abi version") Integer ABIversion, Integer abiVersion, String version, String[] header, AbiFunction[] functions, AbiEvent[] events, AbiData[] data, AbiParam[] fields) {
    }
}

