/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.function.Consumer;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.SubscribeCollectionEvent;
import tech.deplant.java4ever.binding.SubscribeEvent;

public class Net {
    public static ResultOfQuery query(Context ctx, String query, Map<String, Object> variables) throws EverSdkException {
        return ctx.call("net.query", new ParamsOfQuery(query, variables), ResultOfQuery.class);
    }

    public static ResultOfBatchQuery batchQuery(Context ctx, ParamsOfQueryOperation[] operations) throws EverSdkException {
        return ctx.call("net.batch_query", new ParamsOfBatchQuery(operations), ResultOfBatchQuery.class);
    }

    public static ResultOfQueryCollection queryCollection(Context ctx, String collection, Map<String, Object> filter, String result, OrderBy[] order, Number limit) throws EverSdkException {
        return ctx.call("net.query_collection", new ParamsOfQueryCollection(collection, filter, result, order, limit), ResultOfQueryCollection.class);
    }

    public static ResultOfAggregateCollection aggregateCollection(Context ctx, String collection, Map<String, Object> filter, FieldAggregation[] fields) throws EverSdkException {
        return ctx.call("net.aggregate_collection", new ParamsOfAggregateCollection(collection, filter, fields), ResultOfAggregateCollection.class);
    }

    public static ResultOfWaitForCollection waitForCollection(Context ctx, String collection, Map<String, Object> filter, String result, Number timeout) throws EverSdkException {
        return ctx.call("net.wait_for_collection", new ParamsOfWaitForCollection(collection, filter, result, timeout), ResultOfWaitForCollection.class);
    }

    public static void unsubscribe(Context ctx, Number handle) throws EverSdkException {
        ctx.callVoid("net.unsubscribe", new ResultOfSubscribeCollection(handle));
    }

    public static ResultOfSubscribeCollection subscribeCollection(Context ctx, String collection, Map<String, Object> filter, String result, Consumer<SubscribeCollectionEvent> consumer) throws EverSdkException {
        return ctx.callEvent("net.subscribe_collection", new ParamsOfSubscribeCollection(collection, filter, result), consumer, ResultOfSubscribeCollection.class);
    }

    public static ResultOfSubscribeCollection subscribe(Context ctx, String subscription, Map<String, Object> variables, Consumer<SubscribeEvent> consumer) throws EverSdkException {
        return ctx.callEvent("net.subscribe", new ParamsOfSubscribe(subscription, variables), consumer, ResultOfSubscribeCollection.class);
    }

    public static void suspend(Context ctx) throws EverSdkException {
        ctx.callVoid("net.suspend", null);
    }

    public static void resume(Context ctx) throws EverSdkException {
        ctx.callVoid("net.resume", null);
    }

    public static ResultOfFindLastShardBlock findLastShardBlock(Context ctx, String address) throws EverSdkException {
        return ctx.call("net.find_last_shard_block", new ParamsOfFindLastShardBlock(address), ResultOfFindLastShardBlock.class);
    }

    public static EndpointsSet fetchEndpoints(Context ctx) throws EverSdkException {
        return ctx.call("net.fetch_endpoints", null, EndpointsSet.class);
    }

    public static void setEndpoints(Context ctx, String[] endpoints) throws EverSdkException {
        ctx.callVoid("net.set_endpoints", new EndpointsSet(endpoints));
    }

    public static ResultOfGetEndpoints getEndpoints(Context ctx) throws EverSdkException {
        return ctx.call("net.get_endpoints", null, ResultOfGetEndpoints.class);
    }

    public static ResultOfQueryCollection queryCounterparties(Context ctx, String account, String result, Number first, String after) throws EverSdkException {
        return ctx.call("net.query_counterparties", new ParamsOfQueryCounterparties(account, result, first, after), ResultOfQueryCollection.class);
    }

    public static ResultOfQueryTransactionTree queryTransactionTree(Context ctx, String inMsg, Abi.ABI[] abiRegistry, Number timeout) throws EverSdkException {
        return ctx.call("net.query_transaction_tree", new ParamsOfQueryTransactionTree(inMsg, abiRegistry, timeout), ResultOfQueryTransactionTree.class);
    }

    public static RegisteredIterator createBlockIterator(Context ctx, Number startTime, Number endTime, String[] shardFilter, String result) throws EverSdkException {
        return ctx.call("net.create_block_iterator", new ParamsOfCreateBlockIterator(startTime, endTime, shardFilter, result), RegisteredIterator.class);
    }

    public static RegisteredIterator resumeBlockIterator(Context ctx, Map<String, Object> resumeState) throws EverSdkException {
        return ctx.call("net.resume_block_iterator", new ParamsOfResumeBlockIterator(resumeState), RegisteredIterator.class);
    }

    public static RegisteredIterator createTransactionIterator(Context ctx, Number startTime, Number endTime, String[] shardFilter, String[] accountsFilter, String result, Boolean includeTransfers) throws EverSdkException {
        return ctx.call("net.create_transaction_iterator", new ParamsOfCreateTransactionIterator(startTime, endTime, shardFilter, accountsFilter, result, includeTransfers), RegisteredIterator.class);
    }

    public static RegisteredIterator resumeTransactionIterator(Context ctx, Map<String, Object> resumeState, String[] accountsFilter) throws EverSdkException {
        return ctx.call("net.resume_transaction_iterator", new ParamsOfResumeTransactionIterator(resumeState, accountsFilter), RegisteredIterator.class);
    }

    public static ResultOfIteratorNext iteratorNext(Context ctx, Number iterator, Number limit, Boolean returnResumeState) throws EverSdkException {
        return ctx.call("net.iterator_next", new ParamsOfIteratorNext(iterator, limit, returnResumeState), ResultOfIteratorNext.class);
    }

    public static void removeIterator(Context ctx, Number handle) throws EverSdkException {
        ctx.callVoid("net.remove_iterator", new RegisteredIterator(handle));
    }

    public record ParamsOfQuery(String query, Map<String, Object> variables) {
    }

    public record ResultOfQuery(Map<String, Object> result) {
    }

    public record ParamsOfBatchQuery(ParamsOfQueryOperation[] operations) {
    }

    public static interface ParamsOfQueryOperation {

        public record QueryCounterparties(String account, String result, Number first, String after) implements ParamsOfQueryOperation
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record AggregateCollection(String collection, Map<String, Object> filter, FieldAggregation[] fields) implements ParamsOfQueryOperation
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record WaitForCollection(String collection, Map<String, Object> filter, String result, Number timeout) implements ParamsOfQueryOperation
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record QueryCollection(String collection, Map<String, Object> filter, String result, OrderBy[] order, Number limit) implements ParamsOfQueryOperation
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }
    }

    public record ResultOfBatchQuery(Map<String, Object>[] results) {
    }

    public record ParamsOfQueryCollection(String collection, Map<String, Object> filter, String result, OrderBy[] order, Number limit) {
    }

    public record OrderBy(String path, SortDirection direction) {
    }

    public record ResultOfQueryCollection(Map<String, Object>[] result) {
    }

    public record ParamsOfAggregateCollection(String collection, Map<String, Object> filter, FieldAggregation[] fields) {
    }

    public record FieldAggregation(String field, AggregationFn fn) {
    }

    public record ResultOfAggregateCollection(Map<String, Object> values) {
    }

    public record ParamsOfWaitForCollection(String collection, Map<String, Object> filter, String result, Number timeout) {
    }

    public record ResultOfWaitForCollection(Map<String, Object> result) {
    }

    public record ResultOfSubscribeCollection(Number handle) {
    }

    public record ParamsOfSubscribeCollection(String collection, Map<String, Object> filter, String result) {
    }

    public record ParamsOfSubscribe(String subscription, Map<String, Object> variables) {
    }

    public record ParamsOfFindLastShardBlock(String address) {
    }

    public record ResultOfFindLastShardBlock(String blockId) {
    }

    public record EndpointsSet(String[] endpoints) {
    }

    public record ResultOfGetEndpoints(String query, String[] endpoints) {
    }

    public record ParamsOfQueryCounterparties(String account, String result, Number first, String after) {
    }

    public record ParamsOfQueryTransactionTree(String inMsg, Abi.ABI[] abiRegistry, Number timeout) {
    }

    public record ResultOfQueryTransactionTree(MessageNode[] messages, TransactionNode[] transactions) {
    }

    public record ParamsOfCreateBlockIterator(Number startTime, Number endTime, String[] shardFilter, String result) {
    }

    public record RegisteredIterator(Number handle) {
    }

    public record ParamsOfResumeBlockIterator(Map<String, Object> resumeState) {
    }

    public record ParamsOfCreateTransactionIterator(Number startTime, Number endTime, String[] shardFilter, String[] accountsFilter, String result, Boolean includeTransfers) {
    }

    public record ParamsOfResumeTransactionIterator(Map<String, Object> resumeState, String[] accountsFilter) {
    }

    public record ParamsOfIteratorNext(Number iterator, Number limit, Boolean returnResumeState) {
    }

    public record ResultOfIteratorNext(Map<String, Object>[] items, Boolean hasMore, Map<String, Object> resumeState) {
    }

    public record MessageNode(String id, String srcTransactionId, String dstTransactionId, String src, String dst, String value, Boolean bounce, Abi.DecodedMessageBody decodedBody) {
    }

    public record TransactionNode(String id, String inMsg, String[] outMsgs, String accountAddr, String totalFees, Boolean aborted, Number exitCode) {
    }

    public static enum AggregationFn {
        COUNT,
        MIN,
        MAX,
        SUM,
        AVERAGE;

    }

    public static enum SortDirection {
        ASC,
        DESC;

    }
}

