/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.AuthTokenRequestImpl;

@JsonClass(generateAdapter=false)
public interface AuthTokenRequest {
    @NotNull
    public String getMerchantCode();

    @NotNull
    public String getSecret();

    @NotNull
    public Optional<Integer> getValiditySecs();

    @NotNull
    public @NotNull List<@NotNull String> getOperations();

    @NotNull
    public static Builder builder(AuthTokenRequest copyOf) {
        Builder builder = AuthTokenRequest.builder();
        builder.merchantCode(copyOf.getMerchantCode());
        builder.secret(copyOf.getSecret());
        builder.validitySecs(copyOf.getValiditySecs().orElse(null));
        builder.operations(copyOf.getOperations());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new AuthTokenRequestImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder merchantCode(String var1);

        @NotNull
        public Builder secret(String var1);

        @NotNull
        public Builder validitySecs(Integer var1);

        @NotNull
        public Builder operations(List<@NotNull String> var1);

        @NotNull
        public Builder operationsAdd(String var1);

        @NotNull
        public Builder operationsAddAll(List<@NotNull String> var1);

        @NotNull
        public AuthTokenRequest build();
    }
}

