/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.MobileMoneyMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestMobileMoney;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface MobileMoneyMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.MOBILE_MONEY;

    @NotNull
    public AccountPayinRequestMobileMoney getAccount();

    @NotNull
    public Optional<String> getPaymentOperatorCode();

    @NotNull
    public Optional<String> getEmailAddress();

    @NotNull
    public String getPhoneNumber();

    @NotNull
    public static Builder builder(MobileMoneyMethod copyOf) {
        Builder builder = MobileMoneyMethod.builder();
        builder.account(copyOf.getAccount());
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode().orElse(null));
        builder.emailAddress(copyOf.getEmailAddress().orElse(null));
        builder.phoneNumber(copyOf.getPhoneNumber());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new MobileMoneyMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestMobileMoney var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder paymentOperatorCode(String var1);

        public boolean isPaymentOperatorCodeDefined();

        @NotNull
        public Builder emailAddress(String var1);

        public boolean isEmailAddressDefined();

        @NotNull
        public Builder phoneNumber(String var1);

        public boolean isPhoneNumberDefined();

        @NotNull
        public MobileMoneyMethod build();
    }
}

