/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import tech.carpentum.sdk.payment.model.CustomerNetworkAddress;

@JsonClass(generateAdapter=false)
public class CustomerNetworkAddressImpl
implements CustomerNetworkAddress {
    public static final String NETWORK_TYPE_ETHEREUM = "ethereum";
    public static final String NETWORK_TYPE_TRON = "tron";
    private final String networkType;
    private final String networkAddress;
    private final String qrCode;
    private final int hashCode;
    private final String toString;

    @Override
    public String getNetworkType() {
        return this.networkType;
    }

    @Override
    public String getNetworkAddress() {
        return this.networkAddress;
    }

    @Override
    public String getQrCode() {
        return this.qrCode;
    }

    private CustomerNetworkAddressImpl(BuilderImpl builder) {
        this.networkType = Objects.requireNonNull(builder.networkType, "Property 'networkType' is required.");
        this.networkAddress = Objects.requireNonNull(builder.networkAddress, "Property 'networkAddress' is required.");
        this.qrCode = Objects.requireNonNull(builder.qrCode, "Property 'qrCode' is required.");
        this.hashCode = Objects.hash(this.networkType, this.networkAddress, this.qrCode);
        this.toString = builder.type + "(networkType=" + this.networkType + ", networkAddress=" + this.networkAddress + ", qrCode=" + this.qrCode + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerNetworkAddressImpl)) {
            return false;
        }
        CustomerNetworkAddressImpl that = (CustomerNetworkAddressImpl)obj;
        if (!Objects.equals(this.networkType, that.networkType)) {
            return false;
        }
        if (!Objects.equals(this.networkAddress, that.networkAddress)) {
            return false;
        }
        return Objects.equals(this.qrCode, that.qrCode);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements CustomerNetworkAddress.Builder {
        private String networkType = null;
        private String networkAddress = null;
        private String qrCode = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("CustomerNetworkAddress");
        }

        @Override
        public BuilderImpl networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public boolean isNetworkTypeDefined() {
            return this.networkType != null;
        }

        @Override
        public BuilderImpl networkAddress(String networkAddress) {
            this.networkAddress = networkAddress;
            return this;
        }

        @Override
        public boolean isNetworkAddressDefined() {
            return this.networkAddress != null;
        }

        @Override
        public BuilderImpl qrCode(String qrCode) {
            this.qrCode = qrCode;
            return this;
        }

        @Override
        public boolean isQrCodeDefined() {
            return this.qrCode != null;
        }

        @Override
        public CustomerNetworkAddressImpl build() {
            return new CustomerNetworkAddressImpl(this);
        }
    }
}

