/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestEmailTransfer;
import tech.carpentum.sdk.payment.model.EmailTransferMethod;
import tech.carpentum.sdk.payment.model.IdentifyingReference;
import tech.carpentum.sdk.payment.model.PayoutMethod;

@JsonClass(generateAdapter=false)
public class EmailTransferMethodImpl
implements EmailTransferMethod {
    private final String emailAddress;
    private final Optional<AccountPayoutRequestEmailTransfer> account;
    private final IdentifyingReference identifyingReference;
    private final int hashCode;
    private final String toString;

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public Optional<AccountPayoutRequestEmailTransfer> getAccount() {
        return this.account;
    }

    @Override
    public IdentifyingReference getIdentifyingReference() {
        return this.identifyingReference;
    }

    @Override
    public PayoutMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private EmailTransferMethodImpl(BuilderImpl builder) {
        this.emailAddress = Objects.requireNonNull(builder.emailAddress, "Property 'emailAddress' is required.");
        this.account = Optional.ofNullable(builder.account);
        this.identifyingReference = Objects.requireNonNull(builder.identifyingReference, "Property 'identifyingReference' is required.");
        this.hashCode = Objects.hash(this.emailAddress, this.account, this.identifyingReference);
        this.toString = builder.type + "(emailAddress=" + this.emailAddress + ", account=" + this.account + ", identifyingReference=" + this.identifyingReference + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailTransferMethodImpl)) {
            return false;
        }
        EmailTransferMethodImpl that = (EmailTransferMethodImpl)obj;
        if (!Objects.equals(this.emailAddress, that.emailAddress)) {
            return false;
        }
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        return Objects.equals(this.identifyingReference, that.identifyingReference);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements EmailTransferMethod.Builder {
        private String emailAddress = null;
        private AccountPayoutRequestEmailTransfer account = null;
        private IdentifyingReference identifyingReference = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("EmailTransferMethod");
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public boolean isEmailAddressDefined() {
            return this.emailAddress != null;
        }

        @Override
        public BuilderImpl account(AccountPayoutRequestEmailTransfer account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl identifyingReference(IdentifyingReference identifyingReference) {
            this.identifyingReference = identifyingReference;
            return this;
        }

        @Override
        public boolean isIdentifyingReferenceDefined() {
            return this.identifyingReference != null;
        }

        @Override
        public EmailTransferMethodImpl build() {
            return new EmailTransferMethodImpl(this);
        }
    }
}

