/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestBankTransfer;
import tech.carpentum.sdk.payment.model.BankTransferMethod;
import tech.carpentum.sdk.payment.model.IdentifyingReference;
import tech.carpentum.sdk.payment.model.PayoutMethod;

@JsonClass(generateAdapter=false)
public class BankTransferMethodImpl
implements BankTransferMethod {
    private final AccountPayoutRequestBankTransfer account;
    private final Optional<IdentifyingReference> identifyingReference;
    private final Optional<String> paymentOperatorCode;
    private final Optional<String> emailAddress;
    private final Optional<String> phoneNumber;
    private final Optional<String> remark;
    private final int hashCode;
    private final String toString;

    @Override
    public AccountPayoutRequestBankTransfer getAccount() {
        return this.account;
    }

    @Override
    public Optional<IdentifyingReference> getIdentifyingReference() {
        return this.identifyingReference;
    }

    @Override
    public Optional<String> getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public Optional<String> getRemark() {
        return this.remark;
    }

    @Override
    public PayoutMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private BankTransferMethodImpl(BuilderImpl builder) {
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.identifyingReference = Optional.ofNullable(builder.identifyingReference);
        this.paymentOperatorCode = Optional.ofNullable(builder.paymentOperatorCode);
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.phoneNumber = Optional.ofNullable(builder.phoneNumber);
        this.remark = Optional.ofNullable(builder.remark);
        this.hashCode = Objects.hash(this.account, this.identifyingReference, this.paymentOperatorCode, this.emailAddress, this.phoneNumber, this.remark);
        this.toString = builder.type + "(account=" + this.account + ", identifyingReference=" + this.identifyingReference + ", paymentOperatorCode=" + this.paymentOperatorCode + ", emailAddress=" + this.emailAddress + ", phoneNumber=" + this.phoneNumber + ", remark=" + this.remark + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BankTransferMethodImpl)) {
            return false;
        }
        BankTransferMethodImpl that = (BankTransferMethodImpl)obj;
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        if (!Objects.equals(this.identifyingReference, that.identifyingReference)) {
            return false;
        }
        if (!Objects.equals(this.paymentOperatorCode, that.paymentOperatorCode)) {
            return false;
        }
        if (!Objects.equals(this.emailAddress, that.emailAddress)) {
            return false;
        }
        if (!Objects.equals(this.phoneNumber, that.phoneNumber)) {
            return false;
        }
        return Objects.equals(this.remark, that.remark);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements BankTransferMethod.Builder {
        private AccountPayoutRequestBankTransfer account = null;
        private IdentifyingReference identifyingReference = null;
        private String paymentOperatorCode = null;
        private String emailAddress = null;
        private String phoneNumber = null;
        private String remark = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("BankTransferMethod");
        }

        @Override
        public BuilderImpl account(AccountPayoutRequestBankTransfer account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl identifyingReference(IdentifyingReference identifyingReference) {
            this.identifyingReference = identifyingReference;
            return this;
        }

        @Override
        public boolean isIdentifyingReferenceDefined() {
            return this.identifyingReference != null;
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public boolean isPaymentOperatorCodeDefined() {
            return this.paymentOperatorCode != null;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public boolean isEmailAddressDefined() {
            return this.emailAddress != null;
        }

        @Override
        public BuilderImpl phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public boolean isPhoneNumberDefined() {
            return this.phoneNumber != null;
        }

        @Override
        public BuilderImpl remark(String remark) {
            this.remark = remark;
            return this;
        }

        @Override
        public boolean isRemarkDefined() {
            return this.remark != null;
        }

        @Override
        public BankTransferMethodImpl build() {
            return new BankTransferMethodImpl(this);
        }
    }
}

