/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.CustomerDetail;
import tech.carpentum.sdk.payment.model.MoneyFee;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentProcess;
import tech.carpentum.sdk.payment.model.SettlementMethod;
import tech.carpentum.sdk.payment.model.TopUpDetail;
import tech.carpentum.sdk.payment.model.TopUpRequestedDetail;

@JsonClass(generateAdapter=false)
public class TopUpDetailImpl
implements TopUpDetail {
    private final TopUpRequestedDetail topUpRequested;
    private final PaymentProcess process;
    private final MoneyFee fee;
    private final PayinMethodResponse paymentMethodResponse;
    private final Optional<SettlementMethod> settlement;
    private final Optional<CustomerDetail> customer;
    private final int hashCode;
    private final String toString;

    @Override
    public TopUpRequestedDetail getTopUpRequested() {
        return this.topUpRequested;
    }

    @Override
    public PaymentProcess getProcess() {
        return this.process;
    }

    @Override
    public MoneyFee getFee() {
        return this.fee;
    }

    @Override
    public PayinMethodResponse getPaymentMethodResponse() {
        return this.paymentMethodResponse;
    }

    @Override
    public Optional<SettlementMethod> getSettlement() {
        return this.settlement;
    }

    @Override
    public Optional<CustomerDetail> getCustomer() {
        return this.customer;
    }

    private TopUpDetailImpl(BuilderImpl builder) {
        this.topUpRequested = Objects.requireNonNull(builder.topUpRequested, "Property 'topUpRequested' is required.");
        this.process = Objects.requireNonNull(builder.process, "Property 'process' is required.");
        this.fee = Objects.requireNonNull(builder.fee, "Property 'fee' is required.");
        this.paymentMethodResponse = Objects.requireNonNull(builder.paymentMethodResponse, "Property 'paymentMethodResponse' is required.");
        this.settlement = Optional.ofNullable(builder.settlement);
        this.customer = Optional.ofNullable(builder.customer);
        this.hashCode = Objects.hash(this.topUpRequested, this.process, this.fee, this.paymentMethodResponse, this.settlement, this.customer);
        this.toString = builder.type + "(topUpRequested=" + this.topUpRequested + ", process=" + this.process + ", fee=" + this.fee + ", paymentMethodResponse=" + this.paymentMethodResponse + ", settlement=" + this.settlement + ", customer=" + this.customer + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopUpDetailImpl)) {
            return false;
        }
        TopUpDetailImpl that = (TopUpDetailImpl)obj;
        if (!Objects.equals(this.topUpRequested, that.topUpRequested)) {
            return false;
        }
        if (!Objects.equals(this.process, that.process)) {
            return false;
        }
        if (!Objects.equals(this.fee, that.fee)) {
            return false;
        }
        if (!Objects.equals(this.paymentMethodResponse, that.paymentMethodResponse)) {
            return false;
        }
        if (!Objects.equals(this.settlement, that.settlement)) {
            return false;
        }
        return Objects.equals(this.customer, that.customer);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements TopUpDetail.Builder {
        private TopUpRequestedDetail topUpRequested = null;
        private PaymentProcess process = null;
        private MoneyFee fee = null;
        private PayinMethodResponse paymentMethodResponse = null;
        private SettlementMethod settlement = null;
        private CustomerDetail customer = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("TopUpDetail");
        }

        @Override
        public BuilderImpl topUpRequested(TopUpRequestedDetail topUpRequested) {
            this.topUpRequested = topUpRequested;
            return this;
        }

        @Override
        public boolean isTopUpRequestedDefined() {
            return this.topUpRequested != null;
        }

        @Override
        public BuilderImpl process(PaymentProcess process) {
            this.process = process;
            return this;
        }

        @Override
        public boolean isProcessDefined() {
            return this.process != null;
        }

        @Override
        public BuilderImpl fee(MoneyFee fee) {
            this.fee = fee;
            return this;
        }

        @Override
        public boolean isFeeDefined() {
            return this.fee != null;
        }

        @Override
        public BuilderImpl paymentMethodResponse(PayinMethodResponse paymentMethodResponse) {
            this.paymentMethodResponse = paymentMethodResponse;
            return this;
        }

        @Override
        public boolean isPaymentMethodResponseDefined() {
            return this.paymentMethodResponse != null;
        }

        @Override
        public BuilderImpl settlement(SettlementMethod settlement) {
            this.settlement = settlement;
            return this;
        }

        @Override
        public boolean isSettlementDefined() {
            return this.settlement != null;
        }

        @Override
        public BuilderImpl customer(CustomerDetail customer) {
            this.customer = customer;
            return this;
        }

        @Override
        public boolean isCustomerDefined() {
            return this.customer != null;
        }

        @Override
        public TopUpDetailImpl build() {
            return new TopUpDetailImpl(this);
        }
    }
}

