/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PixQRMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestPixQR;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface PixQRMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.PIXQR;

    @NotNull
    public AccountPayinRequestPixQR getAccount();

    @NotNull
    public String getTaxId();

    @NotNull
    public static Builder builder(PixQRMethod copyOf) {
        Builder builder = PixQRMethod.builder();
        builder.account(copyOf.getAccount());
        builder.taxId(copyOf.getTaxId());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new PixQRMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestPixQR var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder taxId(String var1);

        public boolean isTaxIdDefined();

        @NotNull
        public PixQRMethod build();
    }
}

