/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.CodePaymentMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestCodePayment;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface CodePaymentMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.CODE_PAYMENT;

    @NotNull
    public Optional<AccountPayinRequestCodePayment> getAccount();

    @NotNull
    public String getPaymentOperatorCode();

    @NotNull
    public String getEmailAddress();

    @NotNull
    public static Builder builder(CodePaymentMethod copyOf) {
        Builder builder = CodePaymentMethod.builder();
        builder.account(copyOf.getAccount().orElse(null));
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode());
        builder.emailAddress(copyOf.getEmailAddress());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new CodePaymentMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestCodePayment var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder paymentOperatorCode(String var1);

        public boolean isPaymentOperatorCodeDefined();

        @NotNull
        public Builder emailAddress(String var1);

        public boolean isEmailAddressDefined();

        @NotNull
        public CodePaymentMethod build();
    }
}

