/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.infrastructure;

import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiAbstractionsKt;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiClientKt;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiResponse;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Informational;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Redirection;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.RequestConfig;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.RequestMethod;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ResponseExtensionsKt;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Serializer;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Success;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0004J(\u0010\u000f\u001a\u00020\u0010\"\u0006\b\u0000\u0010\u0011\u0018\u00012\u0006\u0010\u0012\u001a\u0002H\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0084\b\u00a2\u0006\u0002\u0010\u0014J4\u0010\u0015\u001a\u0004\u0018\u0001H\u0011\"\f\b\u0000\u0010\u0011\u0018\u0001*\u0004\u0018\u00010\u00012\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0084\b\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0019\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00110\u001cH\u0014J5\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00110\u001e\"\u0006\b\u0000\u0010\u001f\u0018\u0001\"\f\b\u0001\u0010\u0011\u0018\u0001*\u0004\u0018\u00010\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u001cH\u0084\bJ\u0012\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0004J\"\u0010\"\u001a\u00020\u0003\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u00012\u0006\u0010!\u001a\u0002H\u0011H\u0084\b\u00a2\u0006\u0002\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient;", "", "baseUrl", "", "client", "Lokhttp3/OkHttpClient;", "<init>", "(Ljava/lang/String;Lokhttp3/OkHttpClient;)V", "getBaseUrl", "()Ljava/lang/String;", "getClient", "()Lokhttp3/OkHttpClient;", "guessContentTypeFromFile", "file", "Ljava/io/File;", "requestBody", "Lokhttp3/RequestBody;", "T", "content", "mediaType", "(Ljava/lang/Object;Ljava/lang/String;)Lokhttp3/RequestBody;", "responseBody", "body", "Lokhttp3/ResponseBody;", "(Lokhttp3/ResponseBody;Ljava/lang/String;)Ljava/lang/Object;", "updateRequestHeaders", "", "requestConfig", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/RequestConfig;", "request", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiResponse;", "I", "parameterToString", "value", "parseDateToQueryString", "(Ljava/lang/Object;)Ljava/lang/String;", "Companion", "payment-client-v2"})
@SourceDebugExtension(value={"SMAP\nApiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiClient.kt\ntech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n72#1,9:274\n81#1,17:284\n98#1,6:302\n104#1,2:309\n106#1,15:312\n72#1,9:327\n81#1,17:337\n98#1,6:355\n104#1,2:362\n106#1,15:365\n72#1,9:380\n81#1,17:390\n98#1,6:408\n104#1,2:415\n106#1,15:418\n72#1,9:433\n81#1,17:443\n98#1,6:461\n104#1,2:468\n106#1,15:471\n124#1,23:488\n148#1,2:512\n261#1:514\n216#2,2:265\n216#2,2:267\n216#2:270\n217#2:273\n216#2:283\n217#2:301\n216#2:308\n217#2:311\n216#2:336\n217#2:354\n216#2:361\n217#2:364\n216#2:389\n217#2:407\n216#2:414\n217#2:417\n216#2:442\n217#2:460\n216#2:467\n217#2:470\n216#2,2:486\n29#3:269\n29#3:511\n1863#4,2:271\n*S KotlinDebug\n*F\n+ 1 ApiClient.kt\ntech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient\n*L\n198#1:274,9\n198#1:284,17\n198#1:302,6\n198#1:309,2\n198#1:312,15\n201#1:327,9\n201#1:337,17\n201#1:355,6\n201#1:362,2\n201#1:365,15\n202#1:380,9\n202#1:390,17\n202#1:408,6\n202#1:415,2\n202#1:418,15\n203#1:433,9\n203#1:443,17\n203#1:461,6\n203#1:468,2\n203#1:471,15\n226#1:488,23\n226#1:512,2\n250#1:514\n80#1:265,2\n103#1:267,2\n170#1:270\n170#1:273\n198#1:283\n198#1:301\n198#1:308\n198#1:311\n201#1:336\n201#1:354\n201#1:361\n201#1:364\n202#1:389\n202#1:407\n202#1:414\n202#1:417\n203#1:442\n203#1:460\n203#1:467\n203#1:470\n206#1:486,2\n146#1:269\n226#1:511\n171#1:271,2\n*E\n"})
public class ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String baseUrl;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    protected static final String ContentType = "Content-Type";
    @NotNull
    protected static final String Accept = "Accept";
    @NotNull
    public static final String Authorization = "Authorization";
    @NotNull
    protected static final String JsonMediaType = "application/json";
    @NotNull
    protected static final String FormDataMediaType = "multipart/form-data";
    @NotNull
    protected static final String FormUrlEncMediaType = "application/x-www-form-urlencoded";
    @NotNull
    protected static final String XmlMediaType = "application/xml";
    @NotNull
    protected static final String OctetMediaType = "application/octet-stream";
    @NotNull
    private static final Map<String, String> apiKey = new LinkedHashMap();
    @NotNull
    private static final Map<String, String> apiKeyPrefix = new LinkedHashMap();
    @Nullable
    private static String username;
    @Nullable
    private static String password;
    @Nullable
    private static String accessToken;
    @NotNull
    public static final String baseUrlKey = "tech.carpentum.sdk.payment.internal.generated.baseUrl";
    @NotNull
    private static final Lazy<OkHttpClient> defaultClient$delegate;
    @NotNull
    private static final OkHttpClient.Builder builder;

    public ApiClient(@NotNull String baseUrl, @NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.baseUrl = baseUrl;
        this.client = client;
    }

    public /* synthetic */ ApiClient(String string, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            okHttpClient = Companion.getDefaultClient();
        }
        this(string, okHttpClient);
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    @NotNull
    protected final String guessContentTypeFromFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        String string = contentType;
        if (string == null) {
            string = OctetMediaType;
        }
        return string;
    }

    protected final /* synthetic */ <T> RequestBody requestBody(T content, String mediaType) {
        RequestBody requestBody;
        boolean $i$f$requestBody = false;
        if (content instanceof File) {
            File file = (File)content;
            String string = mediaType;
            if (string == null) {
                string = this.guessContentTypeFromFile((File)content);
            }
            requestBody = RequestBody.Companion.create(file, MediaType.Companion.parse(string));
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormDataMediaType)) {
            MultipartBody.Builder builder;
            MultipartBody.Builder $this$requestBody_u24lambda_u241 = builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
            boolean bl = false;
            Intrinsics.checkNotNull(content, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                MultipartBody.Builder builder2;
                Map partHeaders;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl2 = false;
                String name = (String)entry.getKey();
                PartConfig part = (PartConfig)entry.getValue();
                if (part.getBody() instanceof File) {
                    partHeaders = MapsKt.plus((Map)MapsKt.toMutableMap(part.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name + "\"; filename=\"" + ((File)part.getBody()).getName() + "\"")));
                    MediaType fileMediaType = MediaType.Companion.parse(this.guessContentTypeFromFile((File)part.getBody()));
                    builder2 = $this$requestBody_u24lambda_u241.addPart(Headers.Companion.of(partHeaders), RequestBody.Companion.create((File)part.getBody(), fileMediaType));
                    continue;
                }
                partHeaders = MapsKt.plus((Map)MapsKt.toMutableMap(part.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name + "\"")));
                builder2 = $this$requestBody_u24lambda_u241.addPart(Headers.Companion.of(partHeaders), RequestBody.Companion.create(this.parameterToString(part.getBody()), null));
            }
            requestBody = (RequestBody)builder.build();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormUrlEncMediaType)) {
            FormBody.Builder builder;
            FormBody.Builder $this$requestBody_u24lambda_u243 = builder = new FormBody.Builder(null, 1, null);
            boolean bl = false;
            Intrinsics.checkNotNull(content, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl3 = false;
                String name = (String)entry.getKey();
                PartConfig part = (PartConfig)entry.getValue();
                $this$requestBody_u24lambda_u243.add(name, this.parameterToString(part.getBody()));
            }
            requestBody = (RequestBody)builder.build();
        } else if (mediaType == null || StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null)) {
            if (content == null) {
                requestBody = ApiClientKt.getEMPTY_REQUEST();
            } else {
                Moshi moshi = Serializer.getMoshi();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                String string = moshi.adapter(Object.class).toJson(content);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                String string2 = mediaType;
                if (string2 == null) {
                    string2 = JsonMediaType;
                }
                requestBody = RequestBody.Companion.create(string, MediaType.Companion.parse(string2));
            }
        } else {
            if (Intrinsics.areEqual((Object)mediaType, (Object)XmlMediaType)) {
                throw new UnsupportedOperationException("xml not currently supported.");
            }
            if (Intrinsics.areEqual((Object)mediaType, (Object)OctetMediaType) && content instanceof byte[]) {
                requestBody = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])((byte[])content), (MediaType)MediaType.Companion.parse(OctetMediaType), (int)0, (int)0, (int)6, null);
            } else {
                throw new UnsupportedOperationException("requestBody currently only supports JSON body, byte body and File body.");
            }
        }
        return requestBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final /* synthetic */ <T> T responseBody(ResponseBody body, String mediaType) {
        Object object;
        boolean $i$f$responseBody = false;
        if (body == null) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, File.class)) {
            File tempFile = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            Closeable closeable = body.byteStream();
            Throwable throwable = null;
            try {
                long l;
                InputStream inputStream = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)tempFile);
                Closeable closeable2 = new FileOutputStream(tempFile);
                Throwable throwable2 = null;
                try {
                    FileOutputStream tempFileOutputStream = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)tempFileOutputStream, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    InlineMarker.finallyEnd((int)1);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)tempFile;
        }
        if (mediaType == null || StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null)) {
            String bodyContent = body.string();
            if (((CharSequence)bodyContent).length() == 0) {
                return null;
            }
            Moshi $this$adapter$iv = Serializer.getMoshi();
            boolean $i$f$adapter = false;
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            object = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, null).fromJson(bodyContent);
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)OctetMediaType)) {
            byte[] byArray = body.bytes();
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            object = byArray;
        } else {
            throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static /* synthetic */ Object responseBody$default(ApiClient $this, ResponseBody body, String mediaType, int n, Object object) {
        Object object2;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: responseBody");
        }
        if ((n & 2) != 0) {
            mediaType = JsonMediaType;
        }
        boolean $i$f$responseBody = false;
        if (body == null) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, File.class)) {
            File tempFile = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            Closeable closeable = body.byteStream();
            Throwable throwable = null;
            try {
                long l;
                InputStream inputStream = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)tempFile);
                Closeable closeable2 = new FileOutputStream(tempFile);
                Throwable throwable2 = null;
                try {
                    FileOutputStream tempFileOutputStream = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)tempFileOutputStream, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    InlineMarker.finallyEnd((int)1);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return tempFile;
        }
        if (mediaType == null || StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null)) {
            String bodyContent = body.string();
            if (((CharSequence)bodyContent).length() == 0) {
                return null;
            }
            Moshi $this$adapter$iv = Serializer.getMoshi();
            boolean $i$f$adapter = false;
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            object2 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, null).fromJson(bodyContent);
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)OctetMediaType)) {
            byte[] byArray = body.bytes();
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            object2 = byArray;
        } else {
            throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
        }
        return object2;
    }

    protected <T> void updateRequestHeaders(@NotNull RequestConfig<T> requestConfig) {
        block1: {
            Intrinsics.checkNotNullParameter(requestConfig, (String)"requestConfig");
            CharSequence charSequence = requestConfig.getHeaders().get(Authorization);
            if (!(charSequence == null || charSequence.length() == 0)) break block1;
            String string = accessToken;
            if (string != null) {
                String accessToken = string;
                boolean bl = false;
                requestConfig.getHeaders().put(Authorization, "Bearer " + accessToken);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final /* synthetic */ <I, T> ApiResponse<T> request(RequestConfig<I> requestConfig) {
        ApiResponse apiResponse;
        String string;
        Object object;
        String string2;
        Map<String, String> headers;
        Map.Entry<String, List<String>> element$iv;
        Intrinsics.checkNotNullParameter(requestConfig, (String)"requestConfig");
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl2 = httpUrl;
        this.updateRequestHeaders(requestConfig);
        Object object2 = new char[]{'/'};
        object2 = httpUrl2.newBuilder().addEncodedPathSegments(StringsKt.trimStart((String)requestConfig.getPath(), (char[])object2));
        Object $this$request_u24lambda_u249 = (HttpUrl.Builder)object2;
        boolean bl42 = false;
        Request.Builder $this$forEach$iv = requestConfig.getQuery();
        boolean $i$f$forEach = false;
        Object object3 = $this$forEach$iv.entrySet().iterator();
        while (object3.hasNext()) {
            Map.Entry<String, List<String>> query = element$iv = object3.next();
            boolean bl2 = false;
            Iterable iterable = query.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : iterable) {
                String queryValue = (String)element$iv2;
                boolean bl3 = false;
                $this$request_u24lambda_u249.addQueryParameter(query.getKey(), queryValue);
            }
        }
        HttpUrl url = ((HttpUrl.Builder)object2).build();
        if (requestConfig.getBody() != null && ((object2 = (Object)requestConfig.getHeaders().get(ContentType)) == null || object2.length() == 0)) {
            requestConfig.getHeaders().put(ContentType, JsonMediaType);
        }
        if ((object2 = (Object)requestConfig.getHeaders().get(Accept)) == null || object2.length() == 0) {
            requestConfig.getHeaders().put(Accept, JsonMediaType);
        }
        if (($this$request_u24lambda_u249 = (CharSequence)(headers = requestConfig.getHeaders()).get(Accept)) == null || $this$request_u24lambda_u249.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        if (headers.get(ContentType) != null) {
            String string3 = headers.get(ContentType);
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type kotlin.String");
            String bl42 = StringsKt.substringBefore$default((String)string3, (String)";", null, (int)2, null);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string4 = bl42.toLowerCase(locale);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string2 = null;
        }
        String contentType = string2;
        Request.Builder $this$request_u24lambda_u2411 = $this$forEach$iv = (switch (WhenMappings.$EnumSwitchMapping$0[requestConfig.getMethod().ordinal()]) {
            case 1 -> {
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv;
                MediaType fileMediaType$iv;
                Map partHeaders$iv;
                PartConfig part$iv;
                String name$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv;
                Map.Entry var21_85;
                Map $this$forEach$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv;
                RequestBody v7;
                ApiClient this_$iv;
                I content$iv;
                object3 = this;
                element$iv = requestConfig.getBody();
                Request.Builder var28_84 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    File v5 = (File)content$iv;
                    String v6 = contentType;
                    if (v6 == null) {
                        v6 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    v7 = RequestBody.Companion.create(v5, MediaType.Companion.parse(v6));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl2;
                    MultipartBody.Builder var14_35 = bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $i$a$-apply-ApiClient$requestBody$1$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    object = $this$forEach$iv$iv.entrySet().iterator();
                    while (object.hasNext()) {
                        MultipartBody.Builder v8;
                        Map.Entry element$iv$iv;
                        var21_85 = element$iv$iv = object.next();
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv = false;
                        name$iv = (String)var21_85.getKey();
                        part$iv = (PartConfig)var21_85.getValue();
                        if (part$iv.getBody() instanceof File) {
                            partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"; filename=\"" + ((File)part$iv.getBody()).getName() + "\"")));
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)part$iv.getBody()));
                            v8 = var14_35.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create((File)part$iv.getBody(), fileMediaType$iv));
                            continue;
                        }
                        partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"")));
                        v8 = var14_35.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create(this_$iv.parameterToString(part$iv.getBody()), null));
                    }
                    v7 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl2;
                    FormBody.Builder var14_36 = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        var21_85 = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv = false;
                        name$iv = (String)var21_85.getKey();
                        part$iv = (PartConfig)var21_85.getValue();
                        var14_36.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    v7 = (RequestBody)bl2.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        v7 = ApiClientKt.getEMPTY_REQUEST();
                    } else {
                        Moshi v9 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String v10 = v9.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"toJson(...)");
                        String v11 = contentType;
                        if (v11 == null) {
                            v11 = JsonMediaType;
                        }
                        v7 = RequestBody.Companion.create(v10, MediaType.Companion.parse(v11));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType, (Object)OctetMediaType) && content$iv instanceof byte[]) {
                        v7 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])((byte[])content$iv), (MediaType)MediaType.Companion.parse(OctetMediaType), (int)0, (int)0, (int)6, null);
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, byte body and File body.");
                    }
                }
                yield var28_84.delete(v7);
            }
            case 2 -> new Request.Builder().url(url);
            case 3 -> new Request.Builder().url(url).head();
            case 4 -> {
                RequestBody v15;
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv;
                MediaType fileMediaType$iv;
                Map partHeaders$iv;
                PartConfig part$iv;
                String name$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv;
                Map.Entry var21_85;
                Map $this$forEach$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder var28_84 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    File v13 = (File)content$iv;
                    String v14 = contentType;
                    if (v14 == null) {
                        v14 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    v15 = RequestBody.Companion.create(v13, MediaType.Companion.parse(v14));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl2;
                    MultipartBody.Builder var14_38 = bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $i$a$-apply-ApiClient$requestBody$1$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        MultipartBody.Builder v16;
                        var21_85 = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv = false;
                        name$iv = (String)var21_85.getKey();
                        part$iv = (PartConfig)var21_85.getValue();
                        if (part$iv.getBody() instanceof File) {
                            partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"; filename=\"" + ((File)part$iv.getBody()).getName() + "\"")));
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)part$iv.getBody()));
                            v16 = var14_38.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create((File)part$iv.getBody(), fileMediaType$iv));
                            continue;
                        }
                        partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"")));
                        v16 = var14_38.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create(this_$iv.parameterToString(part$iv.getBody()), null));
                    }
                    v15 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl2;
                    FormBody.Builder var14_39 = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        var21_85 = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv = false;
                        name$iv = (String)var21_85.getKey();
                        part$iv = (PartConfig)var21_85.getValue();
                        var14_39.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    v15 = (RequestBody)bl2.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        v15 = ApiClientKt.getEMPTY_REQUEST();
                    } else {
                        Moshi v17 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String v18 = v17.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"toJson(...)");
                        String v19 = contentType;
                        if (v19 == null) {
                            v19 = JsonMediaType;
                        }
                        v15 = RequestBody.Companion.create(v18, MediaType.Companion.parse(v19));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType, (Object)OctetMediaType) && content$iv instanceof byte[]) {
                        v15 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])((byte[])content$iv), (MediaType)MediaType.Companion.parse(OctetMediaType), (int)0, (int)0, (int)6, null);
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, byte body and File body.");
                    }
                }
                yield var28_84.patch(v15);
            }
            case 5 -> {
                RequestBody v22;
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv;
                MediaType fileMediaType$iv;
                Map partHeaders$iv;
                PartConfig part$iv;
                String name$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv;
                Map.Entry var21_85;
                Map $this$forEach$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder var28_84 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    File v20 = (File)content$iv;
                    String v21 = contentType;
                    if (v21 == null) {
                        v21 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    v22 = RequestBody.Companion.create(v20, MediaType.Companion.parse(v21));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl2;
                    MultipartBody.Builder var14_41 = bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $i$a$-apply-ApiClient$requestBody$1$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        MultipartBody.Builder v23;
                        var21_85 = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv = false;
                        name$iv = (String)var21_85.getKey();
                        part$iv = (PartConfig)var21_85.getValue();
                        if (part$iv.getBody() instanceof File) {
                            partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"; filename=\"" + ((File)part$iv.getBody()).getName() + "\"")));
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)part$iv.getBody()));
                            v23 = var14_41.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create((File)part$iv.getBody(), fileMediaType$iv));
                            continue;
                        }
                        partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"")));
                        v23 = var14_41.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create(this_$iv.parameterToString(part$iv.getBody()), null));
                    }
                    v22 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl2;
                    FormBody.Builder var14_42 = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        var21_85 = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv = false;
                        name$iv = (String)var21_85.getKey();
                        part$iv = (PartConfig)var21_85.getValue();
                        var14_42.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    v22 = (RequestBody)bl2.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        v22 = ApiClientKt.getEMPTY_REQUEST();
                    } else {
                        Moshi v24 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String v25 = v24.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v25, (String)"toJson(...)");
                        String v26 = contentType;
                        if (v26 == null) {
                            v26 = JsonMediaType;
                        }
                        v22 = RequestBody.Companion.create(v25, MediaType.Companion.parse(v26));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType, (Object)OctetMediaType) && content$iv instanceof byte[]) {
                        v22 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])((byte[])content$iv), (MediaType)MediaType.Companion.parse(OctetMediaType), (int)0, (int)0, (int)6, null);
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, byte body and File body.");
                    }
                }
                yield var28_84.put(v22);
            }
            case 6 -> {
                RequestBody v29;
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv;
                MediaType fileMediaType$iv;
                Map partHeaders$iv;
                PartConfig part$iv;
                String name$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv;
                Map.Entry var21_85;
                Map $this$forEach$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder var28_84 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    File v27 = (File)content$iv;
                    String v28 = contentType;
                    if (v28 == null) {
                        v28 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    v29 = RequestBody.Companion.create(v27, MediaType.Companion.parse(v28));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl2;
                    MultipartBody.Builder var14_44 = bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $i$a$-apply-ApiClient$requestBody$1$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        MultipartBody.Builder v30;
                        var21_85 = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv = false;
                        name$iv = (String)var21_85.getKey();
                        part$iv = (PartConfig)var21_85.getValue();
                        if (part$iv.getBody() instanceof File) {
                            partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"; filename=\"" + ((File)part$iv.getBody()).getName() + "\"")));
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)part$iv.getBody()));
                            v30 = var14_44.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create((File)part$iv.getBody(), fileMediaType$iv));
                            continue;
                        }
                        partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"")));
                        v30 = var14_44.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create(this_$iv.parameterToString(part$iv.getBody()), null));
                    }
                    v29 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl2;
                    FormBody.Builder var14_45 = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        var21_85 = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv = false;
                        name$iv = (String)var21_85.getKey();
                        part$iv = (PartConfig)var21_85.getValue();
                        var14_45.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    v29 = (RequestBody)bl2.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        v29 = ApiClientKt.getEMPTY_REQUEST();
                    } else {
                        Moshi v31 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String v32 = v31.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v32, (String)"toJson(...)");
                        String v33 = contentType;
                        if (v33 == null) {
                            v33 = JsonMediaType;
                        }
                        v29 = RequestBody.Companion.create(v32, MediaType.Companion.parse(v33));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType, (Object)OctetMediaType) && content$iv instanceof byte[]) {
                        v29 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])((byte[])content$iv), (MediaType)MediaType.Companion.parse(OctetMediaType), (int)0, (int)0, (int)6, null);
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, byte body and File body.");
                    }
                }
                yield var28_84.post(v29);
            }
            case 7 -> new Request.Builder().url(url).method("OPTIONS", null);
            default -> throw new NoWhenBranchMatchedException();
        });
        boolean bl522 = false;
        Map<String, String> $this$forEach$iv3 = headers;
        boolean $i$f$forEach322 = false;
        Iterator<Map.Entry<String, String>> bl2 = $this$forEach$iv3.entrySet().iterator();
        while (bl2.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> header = entry = bl2.next();
            boolean bl6 = false;
            $this$request_u24lambda_u2411.addHeader(header.getKey(), header.getValue());
        }
        Request request = $this$forEach$iv.build();
        Response response = this.getClient().newCall(request).execute();
        String string5 = Response.header$default((Response)response, (String)ContentType, null, (int)2, null);
        if (string5 != null && (string5 = StringsKt.substringBefore$default((String)string5, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach322 = string5;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string6 = $i$f$forEach322.toLowerCase(locale);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String accept = string;
        if (response.isRedirect()) {
            apiResponse = new Redirection(response.code(), response.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response)) {
            apiResponse = new Informational(response.message(), response.code(), response.headers().toMultimap());
        } else if (response.isSuccessful()) {
            Object object4;
            ApiClient bl522 = this;
            ResponseBody body$iv = response.body();
            boolean $i$f$responseBody = false;
            if (body$iv == null) {
                object4 = null;
            } else {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                if (Intrinsics.areEqual(Object.class, File.class)) {
                    File tempFile$iv = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    tempFile$iv.deleteOnExit();
                    Closeable closeable = body$iv.byteStream();
                    Throwable header = null;
                    try {
                        long l;
                        InputStream inputStream$iv = (InputStream)closeable;
                        boolean bl7 = false;
                        Intrinsics.checkNotNull((Object)tempFile$iv);
                        object = new FileOutputStream(tempFile$iv);
                        Throwable throwable = null;
                        try {
                            FileOutputStream tempFileOutputStream$iv = (FileOutputStream)object;
                            boolean bl8 = false;
                            l = ByteStreamsKt.copyTo$default((InputStream)inputStream$iv, (OutputStream)tempFileOutputStream$iv, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            InlineMarker.finallyStart((int)1);
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                            InlineMarker.finallyEnd((int)1);
                        }
                        long l2 = l;
                    }
                    catch (Throwable throwable) {
                        header = throwable;
                        throw throwable;
                    }
                    finally {
                        InlineMarker.finallyStart((int)1);
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)header);
                        InlineMarker.finallyEnd((int)1);
                    }
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
                    object4 = tempFile$iv;
                } else if (accept == null || StringsKt.startsWith$default((String)accept, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept, (String)"json", (boolean)false, (int)2, null)) {
                    String bodyContent$iv = body$iv.string();
                    if (((CharSequence)bodyContent$iv).length() == 0) {
                        object4 = null;
                    } else {
                        Moshi moshi = Serializer.getMoshi();
                        boolean $i$f$adapter = false;
                        Intrinsics.reifiedOperationMarker((int)6, (String)"T?");
                        object4 = _MoshiKotlinExtensionsKt.adapter((Moshi)moshi, null).fromJson(bodyContent$iv);
                    }
                } else if (Intrinsics.areEqual((Object)accept, (Object)OctetMediaType)) {
                    byte[] byArray = body$iv.bytes();
                    Intrinsics.reifiedOperationMarker((int)2, (String)"T?");
                    object4 = byArray;
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            Map map = response.headers().toMultimap();
            int n = response.code();
            Object object5 = object4;
            apiResponse = new Success<Object>(object5, n, (Map<String, List<String>>)((Map<String, ? extends List<String>>)map));
        } else if (ResponseExtensionsKt.isClientError(response)) {
            ResponseBody responseBody = response.body();
            apiResponse = new ClientError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
        } else {
            ResponseBody responseBody = response.body();
            apiResponse = new ServerError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    protected final String parameterToString(@Nullable Object value) {
        String string;
        Object object = value;
        if (object == null) {
            string = "";
        } else if (object instanceof Object[]) {
            string = ApiAbstractionsKt.toMultiValue$default((Object[])value, "csv", null, 4, null).toString();
        } else if (object instanceof Iterable) {
            string = ApiAbstractionsKt.toMultiValue$default((Iterable)value, "csv", null, 4, null).toString();
        } else if (object instanceof OffsetDateTime || object instanceof OffsetTime || object instanceof LocalDateTime || object instanceof LocalDate || object instanceof LocalTime) {
            ApiClient this_$iv = this;
            boolean $i$f$parseDateToQueryString = false;
            String string2 = Serializer.getMoshi().adapter(Object.class).toJson(value);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toJson(...)");
            string = StringsKt.replace$default((String)string2, (String)"\"", (String)"", (boolean)false, (int)4, null);
        } else {
            string = value.toString();
        }
        return string;
    }

    protected final /* synthetic */ <T> String parseDateToQueryString(T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        boolean $i$f$parseDateToQueryString = false;
        Moshi moshi = Serializer.getMoshi();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = moshi.adapter(Object.class).toJson(value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return StringsKt.replace$default((String)string, (String)"\"", (String)"", (boolean)false, (int)4, null);
    }

    private static final OkHttpClient defaultClient_delegate$lambda$12() {
        return builder.build();
    }

    @NotNull
    public static final OkHttpClient getDefaultClient() {
        return Companion.getDefaultClient();
    }

    @NotNull
    public static final OkHttpClient.Builder getBuilder() {
        return Companion.getBuilder();
    }

    static {
        defaultClient$delegate = LazyKt.lazy(ApiClient::defaultClient_delegate$lambda$12);
        builder = new OkHttpClient.Builder();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u000e\u0010\u001e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R!\u0010\u001f\u001a\u00020 8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010%\u0012\u0004\b!\u0010\u0003\u001a\u0004\b\"\u0010#R\u001c\u0010&\u001a\u00020'8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b(\u0010\u0003\u001a\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient$Companion;", "", "<init>", "()V", "ContentType", "", "Accept", "Authorization", "JsonMediaType", "FormDataMediaType", "FormUrlEncMediaType", "XmlMediaType", "OctetMediaType", "apiKey", "", "getApiKey", "()Ljava/util/Map;", "apiKeyPrefix", "getApiKeyPrefix", "username", "getUsername", "()Ljava/lang/String;", "setUsername", "(Ljava/lang/String;)V", "password", "getPassword", "setPassword", "accessToken", "getAccessToken", "setAccessToken", "baseUrlKey", "defaultClient", "Lokhttp3/OkHttpClient;", "getDefaultClient$annotations", "getDefaultClient", "()Lokhttp3/OkHttpClient;", "defaultClient$delegate", "Lkotlin/Lazy;", "builder", "Lokhttp3/OkHttpClient$Builder;", "getBuilder$annotations", "getBuilder", "()Lokhttp3/OkHttpClient$Builder;", "payment-client-v2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getApiKey() {
            return apiKey;
        }

        @NotNull
        public final Map<String, String> getApiKeyPrefix() {
            return apiKeyPrefix;
        }

        @Nullable
        public final String getUsername() {
            return username;
        }

        public final void setUsername(@Nullable String string) {
            username = string;
        }

        @Nullable
        public final String getPassword() {
            return password;
        }

        public final void setPassword(@Nullable String string) {
            password = string;
        }

        @Nullable
        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(@Nullable String string) {
            accessToken = string;
        }

        @NotNull
        public final OkHttpClient getDefaultClient() {
            Lazy lazy = defaultClient$delegate;
            return (OkHttpClient)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultClient$annotations() {
        }

        @NotNull
        public final OkHttpClient.Builder getBuilder() {
            return builder;
        }

        @JvmStatic
        public static /* synthetic */ void getBuilder$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=176)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestMethod.values().length];
            try {
                nArray[RequestMethod.DELETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.GET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.HEAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.PATCH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.PUT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.POST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.OPTIONS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

