/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import tech.carpentum.sdk.payment.model.PaymentRequested;
import tech.carpentum.sdk.payment.model.PayoutAccepted;
import tech.carpentum.sdk.payment.model.PayoutMethodResponse;

@JsonClass(generateAdapter=false)
public class PayoutAcceptedImpl
implements PayoutAccepted {
    private final PaymentRequested paymentRequested;
    private final PayoutMethodResponse paymentMethodResponse;
    private final int hashCode;
    private final String toString;

    @Override
    public PaymentRequested getPaymentRequested() {
        return this.paymentRequested;
    }

    @Override
    public PayoutMethodResponse getPaymentMethodResponse() {
        return this.paymentMethodResponse;
    }

    private PayoutAcceptedImpl(BuilderImpl builder) {
        this.paymentRequested = Objects.requireNonNull(builder.paymentRequested, "Property 'paymentRequested' is required.");
        this.paymentMethodResponse = Objects.requireNonNull(builder.paymentMethodResponse, "Property 'paymentMethodResponse' is required.");
        this.hashCode = Objects.hash(this.paymentRequested, this.paymentMethodResponse);
        this.toString = builder.type + "(paymentRequested=" + this.paymentRequested + ", paymentMethodResponse=" + this.paymentMethodResponse + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PayoutAcceptedImpl)) {
            return false;
        }
        PayoutAcceptedImpl that = (PayoutAcceptedImpl)obj;
        if (!Objects.equals(this.paymentRequested, that.paymentRequested)) {
            return false;
        }
        return Objects.equals(this.paymentMethodResponse, that.paymentMethodResponse);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PayoutAccepted.Builder {
        private PaymentRequested paymentRequested = null;
        private PayoutMethodResponse paymentMethodResponse = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("PayoutAccepted");
        }

        @Override
        public BuilderImpl paymentRequested(PaymentRequested paymentRequested) {
            this.paymentRequested = paymentRequested;
            return this;
        }

        @Override
        public boolean isPaymentRequestedDefined() {
            return this.paymentRequested != null;
        }

        @Override
        public BuilderImpl paymentMethodResponse(PayoutMethodResponse paymentMethodResponse) {
            this.paymentMethodResponse = paymentMethodResponse;
            return this;
        }

        @Override
        public boolean isPaymentMethodResponseDefined() {
            return this.paymentMethodResponse != null;
        }

        @Override
        public PayoutAcceptedImpl build() {
            return new PayoutAcceptedImpl(this);
        }
    }
}

