/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestCryptoTransfer;
import tech.carpentum.sdk.payment.model.CryptoTransferMethod;
import tech.carpentum.sdk.payment.model.PayoutMethod;

@JsonClass(generateAdapter=false)
public class CryptoTransferMethodImpl
implements CryptoTransferMethod {
    private final AccountPayoutRequestCryptoTransfer account;
    private final String paymentOperatorCode;
    private final Optional<String> remark;
    private final int hashCode;
    private final String toString;

    @Override
    public AccountPayoutRequestCryptoTransfer getAccount() {
        return this.account;
    }

    @Override
    public String getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    public Optional<String> getRemark() {
        return this.remark;
    }

    @Override
    public PayoutMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private CryptoTransferMethodImpl(BuilderImpl builder) {
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.paymentOperatorCode = Objects.requireNonNull(builder.paymentOperatorCode, "Property 'paymentOperatorCode' is required.");
        this.remark = Optional.ofNullable(builder.remark);
        this.hashCode = Objects.hash(this.account, this.paymentOperatorCode, this.remark);
        this.toString = builder.type + "(account=" + this.account + ", paymentOperatorCode=" + this.paymentOperatorCode + ", remark=" + this.remark + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CryptoTransferMethodImpl)) {
            return false;
        }
        CryptoTransferMethodImpl that = (CryptoTransferMethodImpl)obj;
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        if (!Objects.equals(this.paymentOperatorCode, that.paymentOperatorCode)) {
            return false;
        }
        return Objects.equals(this.remark, that.remark);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements CryptoTransferMethod.Builder {
        private AccountPayoutRequestCryptoTransfer account = null;
        private String paymentOperatorCode = null;
        private String remark = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("CryptoTransferMethod");
        }

        @Override
        public BuilderImpl account(AccountPayoutRequestCryptoTransfer account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public boolean isPaymentOperatorCodeDefined() {
            return this.paymentOperatorCode != null;
        }

        @Override
        public BuilderImpl remark(String remark) {
            this.remark = remark;
            return this;
        }

        @Override
        public boolean isRemarkDefined() {
            return this.remark != null;
        }

        @Override
        public CryptoTransferMethodImpl build() {
            return new CryptoTransferMethodImpl(this);
        }
    }
}

