/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountResponseOnlyWithBank;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.MoneyPaymentResponse;
import tech.carpentum.sdk.payment.model.MoneyRequired;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.OnlineMethodResponse;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;

@JsonClass(generateAdapter=false)
public class OnlineMethodResponseImpl
implements OnlineMethodResponse {
    private final IdPayin idPayin;
    private final IdPayment idPayment;
    private final AccountResponseOnlyWithBank account;
    private final MoneyPaymentResponse money;
    private final Optional<MoneyRequired> moneyRequired;
    private final Optional<MoneyVat> vat;
    private final String reference;
    private final String returnUrl;
    private final OffsetDateTime acceptedAt;
    private final OffsetDateTime expireAt;
    private final int hashCode;
    private final String toString;

    @Override
    public IdPayin getIdPayin() {
        return this.idPayin;
    }

    @Override
    public IdPayment getIdPayment() {
        return this.idPayment;
    }

    @Override
    public AccountResponseOnlyWithBank getAccount() {
        return this.account;
    }

    @Override
    public MoneyPaymentResponse getMoney() {
        return this.money;
    }

    @Override
    public Optional<MoneyRequired> getMoneyRequired() {
        return this.moneyRequired;
    }

    @Override
    public Optional<MoneyVat> getVat() {
        return this.vat;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public OffsetDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    @Override
    public OffsetDateTime getExpireAt() {
        return this.expireAt;
    }

    @Override
    public PayinMethodResponse.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private OnlineMethodResponseImpl(BuilderImpl builder) {
        this.idPayin = Objects.requireNonNull(builder.idPayin, "Property 'idPayin' is required.");
        this.idPayment = Objects.requireNonNull(builder.idPayment, "Property 'idPayment' is required.");
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.moneyRequired = Optional.ofNullable(builder.moneyRequired);
        this.vat = Optional.ofNullable(builder.vat);
        this.reference = Objects.requireNonNull(builder.reference, "Property 'reference' is required.");
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.acceptedAt = Objects.requireNonNull(builder.acceptedAt, "Property 'acceptedAt' is required.");
        this.expireAt = Objects.requireNonNull(builder.expireAt, "Property 'expireAt' is required.");
        this.hashCode = Objects.hash(this.idPayin, this.idPayment, this.account, this.money, this.moneyRequired, this.vat, this.reference, this.returnUrl, this.acceptedAt, this.expireAt);
        this.toString = builder.type + "(idPayin=" + this.idPayin + ", idPayment=" + this.idPayment + ", account=" + this.account + ", money=" + this.money + ", moneyRequired=" + this.moneyRequired + ", vat=" + this.vat + ", reference=" + this.reference + ", returnUrl=" + this.returnUrl + ", acceptedAt=" + this.acceptedAt + ", expireAt=" + this.expireAt + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnlineMethodResponseImpl)) {
            return false;
        }
        OnlineMethodResponseImpl that = (OnlineMethodResponseImpl)obj;
        if (!Objects.equals(this.idPayin, that.idPayin)) {
            return false;
        }
        if (!Objects.equals(this.idPayment, that.idPayment)) {
            return false;
        }
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        if (!Objects.equals(this.money, that.money)) {
            return false;
        }
        if (!Objects.equals(this.moneyRequired, that.moneyRequired)) {
            return false;
        }
        if (!Objects.equals(this.vat, that.vat)) {
            return false;
        }
        if (!Objects.equals(this.reference, that.reference)) {
            return false;
        }
        if (!Objects.equals(this.returnUrl, that.returnUrl)) {
            return false;
        }
        if (!Objects.equals(this.acceptedAt, that.acceptedAt)) {
            return false;
        }
        return Objects.equals(this.expireAt, that.expireAt);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements OnlineMethodResponse.Builder {
        private IdPayin idPayin = null;
        private IdPayment idPayment = null;
        private AccountResponseOnlyWithBank account = null;
        private MoneyPaymentResponse money = null;
        private MoneyRequired moneyRequired = null;
        private MoneyVat vat = null;
        private String reference = null;
        private String returnUrl = null;
        private OffsetDateTime acceptedAt = null;
        private OffsetDateTime expireAt = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("OnlineMethodResponse");
        }

        @Override
        public BuilderImpl idPayin(IdPayin idPayin) {
            this.idPayin = idPayin;
            return this;
        }

        @Override
        public boolean isIdPayinDefined() {
            return this.idPayin != null;
        }

        @Override
        public BuilderImpl idPayment(IdPayment idPayment) {
            this.idPayment = idPayment;
            return this;
        }

        @Override
        public boolean isIdPaymentDefined() {
            return this.idPayment != null;
        }

        @Override
        public BuilderImpl account(AccountResponseOnlyWithBank account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl money(MoneyPaymentResponse money) {
            this.money = money;
            return this;
        }

        @Override
        public boolean isMoneyDefined() {
            return this.money != null;
        }

        @Override
        public BuilderImpl moneyRequired(MoneyRequired moneyRequired) {
            this.moneyRequired = moneyRequired;
            return this;
        }

        @Override
        public boolean isMoneyRequiredDefined() {
            return this.moneyRequired != null;
        }

        @Override
        public BuilderImpl vat(MoneyVat vat) {
            this.vat = vat;
            return this;
        }

        @Override
        public boolean isVatDefined() {
            return this.vat != null;
        }

        @Override
        public BuilderImpl reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public boolean isReferenceDefined() {
            return this.reference != null;
        }

        @Override
        public BuilderImpl returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @Override
        public boolean isReturnUrlDefined() {
            return this.returnUrl != null;
        }

        @Override
        public BuilderImpl acceptedAt(OffsetDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        @Override
        public boolean isAcceptedAtDefined() {
            return this.acceptedAt != null;
        }

        @Override
        public BuilderImpl expireAt(OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Override
        public boolean isExpireAtDefined() {
            return this.expireAt != null;
        }

        @Override
        public OnlineMethodResponseImpl build() {
            return new OnlineMethodResponseImpl(this);
        }
    }
}

