/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PaymentProcessImpl;
import tech.carpentum.sdk.payment.model.FailureReasons;
import tech.carpentum.sdk.payment.model.PaymentStatus;
import tech.carpentum.sdk.payment.model.ProcessorStatus;

@JsonClass(generateAdapter=false)
public interface PaymentProcess {
    @NotNull
    public PaymentStatus getStatus();

    @NotNull
    public Optional<FailureReasons> getFailureReasons();

    @NotNull
    public OffsetDateTime getCreatedAt();

    @NotNull
    public Optional<OffsetDateTime> getProcessedAt();

    @NotNull
    public Boolean getIsTest();

    @NotNull
    public Optional<ProcessorStatus> getProcessorStatus();

    @NotNull
    public static Builder builder(PaymentProcess copyOf) {
        Builder builder = PaymentProcess.builder();
        builder.status(copyOf.getStatus());
        builder.failureReasons(copyOf.getFailureReasons().orElse(null));
        builder.createdAt(copyOf.getCreatedAt());
        builder.processedAt(copyOf.getProcessedAt().orElse(null));
        builder.isTest(copyOf.getIsTest());
        builder.processorStatus(copyOf.getProcessorStatus().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new PaymentProcessImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder status(PaymentStatus var1);

        @NotNull
        public Builder failureReasons(FailureReasons var1);

        @NotNull
        public Builder createdAt(OffsetDateTime var1);

        @NotNull
        public Builder processedAt(OffsetDateTime var1);

        @NotNull
        public Builder isTest(Boolean var1);

        @NotNull
        public Builder processorStatus(ProcessorStatus var1);

        @NotNull
        public PaymentProcess build();
    }
}

