/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.TopUpRequestedMoneyRequired;

@JsonClass(generateAdapter=false)
public class TopUpRequestedMoneyRequiredImpl
implements TopUpRequestedMoneyRequired {
    private final Money moneyRequired;
    private final Optional<CurrencyCode> currencyProvided;
    private final int hashCode;
    private final String toString;

    @Override
    public Money getMoneyRequired() {
        return this.moneyRequired;
    }

    @Override
    public Optional<CurrencyCode> getCurrencyProvided() {
        return this.currencyProvided;
    }

    private TopUpRequestedMoneyRequiredImpl(BuilderImpl builder) {
        this.moneyRequired = Objects.requireNonNull(builder.moneyRequired, "Property 'moneyRequired' is required.");
        this.currencyProvided = Optional.ofNullable(builder.currencyProvided);
        this.hashCode = Objects.hash(this.moneyRequired, this.currencyProvided);
        this.toString = builder.type + "(moneyRequired=" + this.moneyRequired + ", currencyProvided=" + this.currencyProvided + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopUpRequestedMoneyRequiredImpl)) {
            return false;
        }
        TopUpRequestedMoneyRequiredImpl that = (TopUpRequestedMoneyRequiredImpl)obj;
        if (!Objects.equals(this.moneyRequired, that.moneyRequired)) {
            return false;
        }
        return Objects.equals(this.currencyProvided, that.currencyProvided);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements TopUpRequestedMoneyRequired.Builder {
        private Money moneyRequired = null;
        private CurrencyCode currencyProvided = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("TopUpRequestedMoneyRequired");
        }

        @Override
        public BuilderImpl moneyRequired(Money moneyRequired) {
            this.moneyRequired = moneyRequired;
            return this;
        }

        @Override
        public BuilderImpl currencyProvided(CurrencyCode currencyProvided) {
            this.currencyProvided = currencyProvided;
            return this;
        }

        @Override
        public TopUpRequestedMoneyRequiredImpl build() {
            return new TopUpRequestedMoneyRequiredImpl(this);
        }
    }
}

