/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayinRequestPromptPay;
import tech.carpentum.sdk.payment.model.PayinMethod;
import tech.carpentum.sdk.payment.model.PromptPayMethod;

@JsonClass(generateAdapter=false)
public class PromptPayMethodImpl
implements PromptPayMethod {
    private final Optional<AccountPayinRequestPromptPay> account;
    private final Optional<String> paymentOperatorCode;
    private final Optional<String> emailAddress;
    private final int hashCode;
    private final String toString;

    @Override
    public Optional<AccountPayinRequestPromptPay> getAccount() {
        return this.account;
    }

    @Override
    public Optional<String> getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private PromptPayMethodImpl(BuilderImpl builder) {
        this.account = Optional.ofNullable(builder.account);
        this.paymentOperatorCode = Optional.ofNullable(builder.paymentOperatorCode);
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.hashCode = Objects.hash(this.account, this.paymentOperatorCode, this.emailAddress);
        this.toString = builder.type + "(account=" + this.account + ", paymentOperatorCode=" + this.paymentOperatorCode + ", emailAddress=" + this.emailAddress + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptPayMethodImpl)) {
            return false;
        }
        PromptPayMethodImpl that = (PromptPayMethodImpl)obj;
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        if (!Objects.equals(this.paymentOperatorCode, that.paymentOperatorCode)) {
            return false;
        }
        return Objects.equals(this.emailAddress, that.emailAddress);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PromptPayMethod.Builder {
        private AccountPayinRequestPromptPay account = null;
        private String paymentOperatorCode = null;
        private String emailAddress = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("PromptPayMethod");
        }

        @Override
        public BuilderImpl account(AccountPayinRequestPromptPay account) {
            this.account = account;
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public PromptPayMethodImpl build() {
            return new PromptPayMethodImpl(this);
        }
    }
}

