/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AvailableTopUpOption;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PayinMethodCode;
import tech.carpentum.sdk.payment.model.PaymentOperatorIncoming;

@JsonClass(generateAdapter=false)
public class AvailableTopUpOptionImpl
implements AvailableTopUpOption {
    private final Money moneyPay;
    private final Money moneyReceive;
    private final PayinMethodCode paymentMethodCode;
    private final List<@NotNull PaymentOperatorIncoming> paymentOperators;
    private final int hashCode;
    private final String toString;

    @Override
    public Money getMoneyPay() {
        return this.moneyPay;
    }

    @Override
    public Money getMoneyReceive() {
        return this.moneyReceive;
    }

    @Override
    public PayinMethodCode getPaymentMethodCode() {
        return this.paymentMethodCode;
    }

    @Override
    public List<@NotNull PaymentOperatorIncoming> getPaymentOperators() {
        return this.paymentOperators;
    }

    private AvailableTopUpOptionImpl(BuilderImpl builder) {
        this.moneyPay = Objects.requireNonNull(builder.moneyPay, "Property 'moneyPay' is required.");
        this.moneyReceive = Objects.requireNonNull(builder.moneyReceive, "Property 'moneyReceive' is required.");
        this.paymentMethodCode = Objects.requireNonNull(builder.paymentMethodCode, "Property 'paymentMethodCode' is required.");
        this.paymentOperators = Collections.unmodifiableList(builder.paymentOperators);
        this.hashCode = Objects.hash(this.moneyPay, this.moneyReceive, this.paymentMethodCode, this.paymentOperators);
        this.toString = builder.type + "(moneyPay=" + this.moneyPay + ", moneyReceive=" + this.moneyReceive + ", paymentMethodCode=" + this.paymentMethodCode + ", paymentOperators=" + this.paymentOperators + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailableTopUpOptionImpl)) {
            return false;
        }
        AvailableTopUpOptionImpl that = (AvailableTopUpOptionImpl)obj;
        if (!Objects.equals(this.moneyPay, that.moneyPay)) {
            return false;
        }
        if (!Objects.equals(this.moneyReceive, that.moneyReceive)) {
            return false;
        }
        if (!Objects.equals(this.paymentMethodCode, that.paymentMethodCode)) {
            return false;
        }
        return Objects.equals(this.paymentOperators, that.paymentOperators);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements AvailableTopUpOption.Builder {
        private Money moneyPay = null;
        private Money moneyReceive = null;
        private PayinMethodCode paymentMethodCode = null;
        private List<@NotNull PaymentOperatorIncoming> paymentOperators = new ArrayList<PaymentOperatorIncoming>();
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("AvailableTopUpOption");
        }

        @Override
        public BuilderImpl moneyPay(Money moneyPay) {
            this.moneyPay = moneyPay;
            return this;
        }

        @Override
        public BuilderImpl moneyReceive(Money moneyReceive) {
            this.moneyReceive = moneyReceive;
            return this;
        }

        @Override
        public BuilderImpl paymentMethodCode(PayinMethodCode paymentMethodCode) {
            this.paymentMethodCode = paymentMethodCode;
            return this;
        }

        @Override
        public BuilderImpl paymentOperators(List<@NotNull PaymentOperatorIncoming> paymentOperators) {
            this.paymentOperators.clear();
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorsAdd(PaymentOperatorIncoming item) {
            if (item != null) {
                this.paymentOperators.add(item);
            }
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorsAddAll(List<@NotNull PaymentOperatorIncoming> paymentOperators) {
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        @Override
        public AvailableTopUpOptionImpl build() {
            return new AvailableTopUpOptionImpl(this);
        }
    }
}

