/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountCustomerResponseVaPayVerif;
import tech.carpentum.sdk.payment.model.AccountResponseWithBank;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentOperatorIncoming;
import tech.carpentum.sdk.payment.model.VaPayVerifMethodResponse;

@JsonClass(generateAdapter=false)
public class VaPayVerifMethodResponseImpl
implements VaPayVerifMethodResponse {
    private final IdPayin idPayin;
    private final IdPayment idPayment;
    private final AccountResponseWithBank account;
    private final AccountCustomerResponseVaPayVerif accountCustomer;
    private final Money money;
    private final Optional<MoneyVat> vat;
    private final String reference;
    private final String returnUrl;
    private final PaymentOperatorIncoming paymentOperator;
    private final OffsetDateTime acceptedAt;
    private final OffsetDateTime expireAt;
    private final int hashCode;
    private final String toString;

    @Override
    public IdPayin getIdPayin() {
        return this.idPayin;
    }

    @Override
    public IdPayment getIdPayment() {
        return this.idPayment;
    }

    @Override
    public AccountResponseWithBank getAccount() {
        return this.account;
    }

    @Override
    public AccountCustomerResponseVaPayVerif getAccountCustomer() {
        return this.accountCustomer;
    }

    @Override
    public Money getMoney() {
        return this.money;
    }

    @Override
    public Optional<MoneyVat> getVat() {
        return this.vat;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public PaymentOperatorIncoming getPaymentOperator() {
        return this.paymentOperator;
    }

    @Override
    public OffsetDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    @Override
    public OffsetDateTime getExpireAt() {
        return this.expireAt;
    }

    @Override
    public PayinMethodResponse.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private VaPayVerifMethodResponseImpl(BuilderImpl builder) {
        this.idPayin = Objects.requireNonNull(builder.idPayin, "Property 'idPayin' is required.");
        this.idPayment = Objects.requireNonNull(builder.idPayment, "Property 'idPayment' is required.");
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.accountCustomer = Objects.requireNonNull(builder.accountCustomer, "Property 'accountCustomer' is required.");
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.vat = Optional.ofNullable(builder.vat);
        this.reference = Objects.requireNonNull(builder.reference, "Property 'reference' is required.");
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.paymentOperator = Objects.requireNonNull(builder.paymentOperator, "Property 'paymentOperator' is required.");
        this.acceptedAt = Objects.requireNonNull(builder.acceptedAt, "Property 'acceptedAt' is required.");
        this.expireAt = Objects.requireNonNull(builder.expireAt, "Property 'expireAt' is required.");
        this.hashCode = Objects.hash(this.idPayin, this.idPayment, this.account, this.accountCustomer, this.money, this.vat, this.reference, this.returnUrl, this.paymentOperator, this.acceptedAt, this.expireAt);
        this.toString = builder.type + "(idPayin=" + this.idPayin + ", idPayment=" + this.idPayment + ", account=" + this.account + ", accountCustomer=" + this.accountCustomer + ", money=" + this.money + ", vat=" + this.vat + ", reference=" + this.reference + ", returnUrl=" + this.returnUrl + ", paymentOperator=" + this.paymentOperator + ", acceptedAt=" + this.acceptedAt + ", expireAt=" + this.expireAt + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VaPayVerifMethodResponseImpl)) {
            return false;
        }
        VaPayVerifMethodResponseImpl that = (VaPayVerifMethodResponseImpl)obj;
        if (!Objects.equals(this.idPayin, that.idPayin)) {
            return false;
        }
        if (!Objects.equals(this.idPayment, that.idPayment)) {
            return false;
        }
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        if (!Objects.equals(this.accountCustomer, that.accountCustomer)) {
            return false;
        }
        if (!Objects.equals(this.money, that.money)) {
            return false;
        }
        if (!Objects.equals(this.vat, that.vat)) {
            return false;
        }
        if (!Objects.equals(this.reference, that.reference)) {
            return false;
        }
        if (!Objects.equals(this.returnUrl, that.returnUrl)) {
            return false;
        }
        if (!Objects.equals(this.paymentOperator, that.paymentOperator)) {
            return false;
        }
        if (!Objects.equals(this.acceptedAt, that.acceptedAt)) {
            return false;
        }
        return Objects.equals(this.expireAt, that.expireAt);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements VaPayVerifMethodResponse.Builder {
        private IdPayin idPayin = null;
        private IdPayment idPayment = null;
        private AccountResponseWithBank account = null;
        private AccountCustomerResponseVaPayVerif accountCustomer = null;
        private Money money = null;
        private MoneyVat vat = null;
        private String reference = null;
        private String returnUrl = null;
        private PaymentOperatorIncoming paymentOperator = null;
        private OffsetDateTime acceptedAt = null;
        private OffsetDateTime expireAt = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("VaPayVerifMethodResponse");
        }

        @Override
        public BuilderImpl idPayin(IdPayin idPayin) {
            this.idPayin = idPayin;
            return this;
        }

        @Override
        public BuilderImpl idPayment(IdPayment idPayment) {
            this.idPayment = idPayment;
            return this;
        }

        @Override
        public BuilderImpl account(AccountResponseWithBank account) {
            this.account = account;
            return this;
        }

        @Override
        public BuilderImpl accountCustomer(AccountCustomerResponseVaPayVerif accountCustomer) {
            this.accountCustomer = accountCustomer;
            return this;
        }

        @Override
        public BuilderImpl money(Money money) {
            this.money = money;
            return this;
        }

        @Override
        public BuilderImpl vat(MoneyVat vat) {
            this.vat = vat;
            return this;
        }

        @Override
        public BuilderImpl reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public BuilderImpl returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @Override
        public BuilderImpl paymentOperator(PaymentOperatorIncoming paymentOperator) {
            this.paymentOperator = paymentOperator;
            return this;
        }

        @Override
        public BuilderImpl acceptedAt(OffsetDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        @Override
        public BuilderImpl expireAt(OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Override
        public VaPayVerifMethodResponseImpl build() {
            return new VaPayVerifMethodResponseImpl(this);
        }
    }
}

