/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.PayinMethod;
import tech.carpentum.sdk.payment.model.UpiQRMethod;

@JsonClass(generateAdapter=false)
public class UpiQRMethodImpl
implements UpiQRMethod {
    private final Optional<String> upiId;
    private final Optional<String> emailAddress;
    private final Optional<String> paymentOperatorCode;
    private final int hashCode;
    private final String toString;

    @Override
    public Optional<String> getUpiId() {
        return this.upiId;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public Optional<String> getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private UpiQRMethodImpl(BuilderImpl builder) {
        this.upiId = Optional.ofNullable(builder.upiId);
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.paymentOperatorCode = Optional.ofNullable(builder.paymentOperatorCode);
        this.hashCode = Objects.hash(this.upiId, this.emailAddress, this.paymentOperatorCode);
        this.toString = builder.type + "(upiId=" + this.upiId + ", emailAddress=" + this.emailAddress + ", paymentOperatorCode=" + this.paymentOperatorCode + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpiQRMethodImpl)) {
            return false;
        }
        UpiQRMethodImpl that = (UpiQRMethodImpl)obj;
        if (!Objects.equals(this.upiId, that.upiId)) {
            return false;
        }
        if (!Objects.equals(this.emailAddress, that.emailAddress)) {
            return false;
        }
        return Objects.equals(this.paymentOperatorCode, that.paymentOperatorCode);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements UpiQRMethod.Builder {
        private String upiId = null;
        private String emailAddress = null;
        private String paymentOperatorCode = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("UpiQRMethod");
        }

        @Override
        public BuilderImpl upiId(String upiId) {
            this.upiId = upiId;
            return this;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public UpiQRMethodImpl build() {
            return new UpiQRMethodImpl(this);
        }
    }
}

