/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.TopUpRequestedMoneyProvidedImpl;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.TopUpRequested;

@JsonClass(generateAdapter=false)
public interface TopUpRequestedMoneyProvided
extends TopUpRequested {
    public static final TopUpRequested.TopUpRequestedType TOP_UP_REQUESTED_TYPE = TopUpRequested.TopUpRequestedType.MONEY_PROVIDED;

    @NotNull
    public Money getMoneyProvided();

    @NotNull
    public Optional<CurrencyCode> getCurrencyRequired();

    @NotNull
    public static Builder builder(TopUpRequestedMoneyProvided copyOf) {
        Builder builder = TopUpRequestedMoneyProvided.builder();
        builder.moneyProvided(copyOf.getMoneyProvided());
        builder.currencyRequired(copyOf.getCurrencyRequired().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new TopUpRequestedMoneyProvidedImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder moneyProvided(Money var1);

        @NotNull
        public Builder currencyRequired(CurrencyCode var1);

        @NotNull
        public TopUpRequestedMoneyProvided build();
    }
}

