/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PayMeMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestPayMe;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface PayMeMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.PAY_ME;

    @NotNull
    public AccountPayinRequestPayMe getAccount();

    @NotNull
    public Optional<String> getEmailAddress();

    @NotNull
    public Optional<String> getPhoneNumber();

    @NotNull
    public static Builder builder(PayMeMethod copyOf) {
        Builder builder = PayMeMethod.builder();
        builder.account(copyOf.getAccount());
        builder.emailAddress(copyOf.getEmailAddress().orElse(null));
        builder.phoneNumber(copyOf.getPhoneNumber().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new PayMeMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestPayMe var1);

        @NotNull
        public Builder emailAddress(String var1);

        @NotNull
        public Builder phoneNumber(String var1);

        @NotNull
        public PayMeMethod build();
    }
}

