/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AvailablePayoutOption;
import tech.carpentum.sdk.payment.model.PaymentOperatorOutgoing;
import tech.carpentum.sdk.payment.model.PayoutMethodCode;
import tech.carpentum.sdk.payment.model.SegmentCode;

@JsonClass(generateAdapter=false)
public class AvailablePayoutOptionImpl
implements AvailablePayoutOption {
    private final PayoutMethodCode paymentMethodCode;
    private final List<@NotNull PaymentOperatorOutgoing> paymentOperators;
    private final Optional<SegmentCode> segmentCode;
    private final int hashCode;
    private final String toString;

    @Override
    public PayoutMethodCode getPaymentMethodCode() {
        return this.paymentMethodCode;
    }

    @Override
    public List<@NotNull PaymentOperatorOutgoing> getPaymentOperators() {
        return this.paymentOperators;
    }

    @Override
    public Optional<SegmentCode> getSegmentCode() {
        return this.segmentCode;
    }

    private AvailablePayoutOptionImpl(BuilderImpl builder) {
        this.paymentMethodCode = Objects.requireNonNull(builder.paymentMethodCode, "Property 'paymentMethodCode' is required.");
        this.paymentOperators = Collections.unmodifiableList(builder.paymentOperators);
        this.segmentCode = Optional.ofNullable(builder.segmentCode);
        this.hashCode = Objects.hash(this.paymentMethodCode, this.paymentOperators, this.segmentCode);
        this.toString = builder.type + "(paymentMethodCode=" + this.paymentMethodCode + ", paymentOperators=" + this.paymentOperators + ", segmentCode=" + this.segmentCode + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailablePayoutOptionImpl)) {
            return false;
        }
        AvailablePayoutOptionImpl that = (AvailablePayoutOptionImpl)obj;
        if (!Objects.equals(this.paymentMethodCode, that.paymentMethodCode)) {
            return false;
        }
        if (!Objects.equals(this.paymentOperators, that.paymentOperators)) {
            return false;
        }
        return Objects.equals(this.segmentCode, that.segmentCode);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements AvailablePayoutOption.Builder {
        private PayoutMethodCode paymentMethodCode = null;
        private List<@NotNull PaymentOperatorOutgoing> paymentOperators = new ArrayList<PaymentOperatorOutgoing>();
        private SegmentCode segmentCode = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("AvailablePayoutOption");
        }

        @Override
        public BuilderImpl paymentMethodCode(PayoutMethodCode paymentMethodCode) {
            this.paymentMethodCode = paymentMethodCode;
            return this;
        }

        @Override
        public BuilderImpl paymentOperators(List<@NotNull PaymentOperatorOutgoing> paymentOperators) {
            this.paymentOperators.clear();
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorsAdd(PaymentOperatorOutgoing item) {
            if (item != null) {
                this.paymentOperators.add(item);
            }
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorsAddAll(List<@NotNull PaymentOperatorOutgoing> paymentOperators) {
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        @Override
        public BuilderImpl segmentCode(SegmentCode segmentCode) {
            this.segmentCode = segmentCode;
            return this;
        }

        @Override
        public AvailablePayoutOptionImpl build() {
            return new AvailablePayoutOptionImpl(this);
        }
    }
}

