/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.WalletTransferMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestWalletTransfer;
import tech.carpentum.sdk.payment.model.PayoutMethod;

@JsonClass(generateAdapter=false)
public interface WalletTransferMethod
extends PayoutMethod {
    public static final PayoutMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayoutMethod.PaymentMethodCode.WALLET_TRANSFER;

    @NotNull
    public AccountPayoutRequestWalletTransfer getAccount();

    @NotNull
    public Optional<String> getPaymentOperatorCode();

    @NotNull
    public Optional<String> getPhoneNumber();

    @NotNull
    public Optional<String> getRemark();

    @NotNull
    public static Builder builder(WalletTransferMethod copyOf) {
        Builder builder = WalletTransferMethod.builder();
        builder.account(copyOf.getAccount());
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode().orElse(null));
        builder.phoneNumber(copyOf.getPhoneNumber().orElse(null));
        builder.remark(copyOf.getRemark().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new WalletTransferMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayoutRequestWalletTransfer var1);

        @NotNull
        public Builder paymentOperatorCode(String var1);

        @NotNull
        public Builder phoneNumber(String var1);

        @NotNull
        public Builder remark(String var1);

        @NotNull
        public WalletTransferMethod build();
    }
}

