/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayinRequestCapitecPay;
import tech.carpentum.sdk.payment.model.CapitecPayMethod;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class CapitecPayMethodImpl
implements CapitecPayMethod {
    private final Optional<AccountPayinRequestCapitecPay> account;
    private final Optional<String> phoneNumber;
    private final Optional<String> said;
    private final int hashCode;
    private final String toString;

    @Override
    public Optional<AccountPayinRequestCapitecPay> getAccount() {
        return this.account;
    }

    @Override
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public Optional<String> getSaid() {
        return this.said;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private CapitecPayMethodImpl(BuilderImpl builder) {
        this.account = Optional.ofNullable(builder.account);
        this.phoneNumber = Optional.ofNullable(builder.phoneNumber);
        this.said = Optional.ofNullable(builder.said);
        this.hashCode = Objects.hash(this.account, this.phoneNumber, this.said);
        this.toString = builder.type + "(account=" + this.account + ", phoneNumber=" + this.phoneNumber + ", said=" + this.said + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapitecPayMethodImpl)) {
            return false;
        }
        CapitecPayMethodImpl that = (CapitecPayMethodImpl)obj;
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.phoneNumber.equals(that.phoneNumber)) {
            return false;
        }
        return this.said.equals(that.said);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements CapitecPayMethod.Builder {
        private AccountPayinRequestCapitecPay account = null;
        private String phoneNumber = null;
        private String said = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("CapitecPayMethod");
        }

        @Override
        public BuilderImpl account(AccountPayinRequestCapitecPay account) {
            this.account = account;
            return this;
        }

        @Override
        public BuilderImpl phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public BuilderImpl said(String said) {
            this.said = said;
            return this;
        }

        @Override
        public CapitecPayMethodImpl build() {
            return new CapitecPayMethodImpl(this);
        }
    }
}

